struct stat buf;
DIR *dir;
struct dirent *dirpointer;
GtkWidget *dialog=NULL;
gchar *com_com=NULL;
#ifndef DESKYPPLET_H
#define DESKYPPLET_H

#include <glib-object.h>

#include <libhildondesktop/libhildondesktop.h>

G_BEGIN_DECLS

#define APPLET_X_SIZE 450
#define APPLET_Y_SIZE 300
#define TOOLBAR_Y_SIZE 3

#define MIN_X_SIZE 140
#define MAX_X_SIZE 800
#define MIN_Y_SIZE 140
#define MAX_Y_SIZE 420

#define SETTINGS_PATH	".deskypplet"
/*#define EXISTING_NOTE	"note"*/
#define PREFS_FILE	"deskypplet.conf"

#define DEFAULT_COLOR		"#ffff00"
#define DEFAULT_FONT_COLOR	"#000000"
#define DEFAULT_FONT		"Sans 12"
#define DEFAULT_BG_ALPHA	50



typedef struct _DeskYppletPlugin DeskYppletPlugin;
typedef struct _DeskYppletPluginClass DeskYppletPluginClass;

#define DESKYPPLET_TYPE_HOME_PLUGIN   (deskypplet_home_plugin_get_type ())

#define DESKYPPLET_HOME_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
			                        DESKYPPLET_TYPE_HOME_PLUGIN, DeskYppletHomePlugin))

#define DESKYPPLET_HOME_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), \
			                        DESKYPPLET_TYPE_HOME_PLUGIN,  DeskYppletPluginClass))

#define DESKYPPLET_IS_HOME_PLUGIN(obj)  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
			                        DESKYPPLET_TYPE_HOME_PLUGIN))
 
#define DESKYPPLET_IS_HOME_PLUGIN_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), \
			                        DESKYPPLET_TYPE_HOME_PLUGIN))

#define DESKYPPLET_HOME_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), \
			                        DESKYPPLET_TYPE_HOME_PLUGIN,  DeskYppletHomePluginClass))
 
struct _DeskYppletPlugin
{
	    HDHomePluginItem hitem;
};
 
struct _DeskYppletPluginClass
{
	    HDHomePluginItemClass parent_class;
};
 
GType deskypplet_plugin_get_type(void);

HD_DEFINE_PLUGIN_MODULE (DeskYppletPlugin, deskypplet_plugin, HD_TYPE_HOME_PLUGIN_ITEM);

static void deskypplet_plugin_realize (GtkWidget *widget);
static gboolean deskypplet_plugin_expose_event(GtkWidget *widget, GdkEventExpose *event);

typedef struct
{
	DeskYppletPlugin *parent;
	
    GtkWidget *frame;
	GtkWidget *vbox;
	GtkWidget *vbox_fb;	
	GtkWidget *hbox_toolb;
	GtkWidget *top;
	GtkScrolledWindow *scrolledwindow_fb;
	GtkWidget *table;

	GtkWidget *path_label;
	GtkWidget *vscroll;
	GtkWidget *hscroll;
	GtkWidget *label_evbox;
	GtkWidget *folder_up_evbox;
	GtkWidget *folder_up_image;
	GtkWidget *folder_home_evbox;
	GtkWidget *folder_home_image;
		
	GtkTextBuffer *buffer;
	
	GdkColor color;
	GdkColor fontcolor;
	
	gchar *fontname;
	
	gchar *prefs_dir;
	gchar *conf_file;
    gchar *work_dir;
	gchar *home_dir;
	
	gfloat bg_alpha;

	gint applet_x_size;
	gint applet_y_size;
	gint *locked;
	  
} YNCtx;

/*adjusting width and height not to exceed max size allowed*/
void adjust_settings(YNCtx *app);

/*read preferences from config file and load into object*/
void load_applet_prefs(YNCtx *app);

/*callback to get background color selection*/
void select_bg_color(GObject *o, YNCtx *app);

/*callback to get text font selection*/
void select_font(GObject *o, YNCtx *app);

/*callback to get font color selection*/
void select_font_color(GObject *o, YNCtx *app);

/*function to apply color and alpha value to widget using cairo*/
void set_cairo_transparency(GdkDrawable *drawable, GdkEventExpose *event, GdkColor color, gfloat alpha);

/*callback to show settings dialog (settings button) --not used in fremantle*/
gboolean configure_applet_button(GObject *o,GdkEventButton *event,YNCtx *app);

/*callback to show settings dialog in Desktop editing mode (fremantle)*/
gboolean configure_applet(GtkWidget *o,YNCtx *app);

/*create desktop widget applet and build UI*/
void mkplugin_create_home_applet(YNCtx *app);
void build_ui(void);

void menu (void);

static gboolean handle_expose (GtkWidget *widget, GdkEventExpose *event);


/*handle rotation*/
static gboolean is_portrait ();
void on_orientation_changed(GdkScreen *screen,YNCtx *app);

void folder_down (GObject *o,GdkEventButton *event,gchar *fullpath);
void bookmark (gpointer button,gchar *fullpath);
void custom_com (gpointer button,gchar *com_do);
void term_her (void);
void book_this (void);

void go_folder_up (GObject *o,GdkEventButton *event,YNCtx *app);
void go_folder_home (GObject *o,GdkEventButton *event,YNCtx *app);
void create_table (YNCtx *app);
void yppletactions(YNCtx *app);
void do_it (void);
int myComparisonFunction(const void *x, const void *y);
gchar *g_get_free_space ( gchar * dev_path);
gchar *g_get_capacity ( gchar * dev_path);
/*widget style to unset sapwood engine for scrollbar.
RGBA colormap has conflict with default theme's PNGs*/
gchar *scroll_style="style \"my-style\" \
{ \
	bg[NORMAL] = \"#5A5A5A\" \
	bg[ACTIVE] = \"#202020\" \
        GtkRange::stepper_size = 60 \
        GtkRange::stepper_spacing = 0 \
        GtkRange::trough_border = 0 \
        GtkRange::slider_width = 40 \
        GtkRange::draw_trough_under_steppers = 1 \
        GtkRange::draw_trough = 1 \
        GtkRange::arrow_displacement_x = 0 \
        GtkRange::arrow_displacement_y = 0 \
        GtkRange::autodimmed_steppers = 1 \
        GtkScrollbar::min-slider-length = 32 \
	GtkScrollbar::scrollbar-spacing = 0 \
        GtkRange::activate-slider = 1 \
	engine \"\" { } \
} \
class \"GtkScrollbar\" style \"my-style\"";

G_END_DECLS

#endif
