/*
 * deskypplet: a maemo home applet for partial desktop experience
 * Copyright (C) 2011 sethkha
 * partofit:Yellownotes
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option); any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


/*
#include <hildon/hildon-program.h>
 Pull in the GnomeVFS headers (NEW). 
#include <libgnomevfs/gnome-vfs.h>*/
 

#include <dirent.h>
#include <gtk/gtk.h>
#include <hildon/hildon.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <strings.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <libhildondesktop/libhildondesktop.h>
#include "deskypplet.h"
#include <hildon-mime.h>
#include <libosso.h>
#include <sys/statvfs.h>
#include <glib.h>


YNCtx *app=NULL;

void adjust_settings(YNCtx *app)
{
	if(app->applet_x_size<MIN_X_SIZE)
		app->applet_x_size=MIN_X_SIZE;
	if(app->applet_x_size>MAX_X_SIZE)
		app->applet_x_size=MAX_X_SIZE;

	if(app->applet_y_size<MIN_Y_SIZE)
		app->applet_y_size=MIN_Y_SIZE;
	if(app->applet_y_size>MAX_Y_SIZE)
		app->applet_y_size=MAX_Y_SIZE;

	app->bg_alpha=1-(app->bg_alpha/100);
}

void load_applet_prefs(YNCtx *app)
{
	GIOChannel *f=NULL;
	GIOStatus st;
	GdkColormap *colormap;
	gchar *readbuf=NULL;
	gchar *fontbuffer=NULL;
	gchar *homedir=NULL;
	gchar *red=NULL;
	gchar *green=NULL;
	gchar *blue=NULL;

	homedir=(gchar *)getenv("HOME");

	app->prefs_dir=g_new0(gchar,strlen(homedir)+strlen(SETTINGS_PATH)+5);
	sprintf(app->prefs_dir,"%s/%s",homedir,SETTINGS_PATH);	

	app->conf_file=g_new0(gchar,strlen(homedir)+strlen(SETTINGS_PATH)+strlen(PREFS_FILE)+5);
	sprintf(app->conf_file,"%s/%s/%s",homedir,SETTINGS_PATH,PREFS_FILE);


	app->locked=g_new0(gint,1);
	*app->locked=FALSE;

	g_print("Loading applet preferences\n");
	if(chdir(app->prefs_dir)<0)
	{
		g_print("Creating preferences directory\n");
		/*create settings directory in user's home*/
		if(mkdir(app->prefs_dir,(mode_t)0755) < 0)
			g_print("Error creating settings directory\n");
	}

	g_print("Loading default values\n");
	app->applet_x_size=APPLET_X_SIZE;
	app->applet_y_size=APPLET_Y_SIZE;
	gdk_color_parse (DEFAULT_COLOR, &(app->color));
	gdk_color_parse (DEFAULT_FONT_COLOR, &(app->fontcolor));
	app->fontname=g_new0(gchar,strlen(DEFAULT_FONT)+1);
	strcpy(app->fontname,DEFAULT_FONT);
	app->bg_alpha=(gfloat)DEFAULT_BG_ALPHA/100;
    app->work_dir="/home/user";
	
	f=g_io_channel_new_file(app->conf_file,"r",NULL);

	if(f!=NULL)
	{
		while((st=g_io_channel_read_line(f,&readbuf,NULL,NULL,NULL) )!=G_IO_STATUS_EOF)
		{
		
			if(strstr(readbuf,"width"))
				sscanf(readbuf,"width=%d\n",&(app->applet_x_size));
			if(strstr(readbuf,"height"))
				sscanf(readbuf,"height=%d\n",&(app->applet_y_size));
			if(strstr(readbuf,"bgcolor="))
			{
				red=strchr(readbuf,'=')+1;
				green=strchr(red,',');
				*green=0;
				green+=1;
				blue=strchr(green,',');
				*blue=0;
				blue+=1;
				fontbuffer=strchr(blue,'\n');
				*fontbuffer=0;
				(app->color).red=(guint16)atoi(red);
				(app->color).green=(guint16)atoi(green);
				(app->color).blue=(guint16)atoi(blue);
				colormap=gdk_colormap_get_system();
				gdk_colormap_alloc_color(colormap,&(app->color),TRUE,TRUE);
			}
			if(strstr(readbuf,"bgalpha"))
			{
				gint alpha;
				sscanf(readbuf,"bgalpha=%d\n",&alpha);
				app->bg_alpha=(gfloat)alpha/100;
				
			}
			if(strstr(readbuf,"font="))
			{
				fontbuffer=strchr(readbuf,'\n');
				*fontbuffer=0;
				fontbuffer=strchr(readbuf,'=')+1;
				app->fontname=g_new0(gchar,strlen(fontbuffer)+1);
				strcpy(app->fontname,fontbuffer);
			}
			if(strstr(readbuf,"startdir="))
			{
				fontbuffer=strchr(readbuf,'\n');
				*fontbuffer=0;
				fontbuffer=strchr(readbuf,'=')+1;
				app->work_dir=g_new0(gchar,strlen(fontbuffer)+1);
				strcpy(app->work_dir,fontbuffer);
			}
			if(strstr(readbuf,"fontcolor"))
			{
				red=strchr(readbuf,'=')+1;
				green=strchr(red,',');
				*green=0;
				green+=1;
				blue=strchr(green,',');
				*blue=0;
				blue+=1;
				fontbuffer=strchr(blue,'\n');
				*fontbuffer=0;
				(app->fontcolor).red=(guint16)atoi(red);
				(app->fontcolor).green=(guint16)atoi(green);
				(app->fontcolor).blue=(guint16)atoi(blue);
				colormap=gdk_colormap_get_system();
				gdk_colormap_alloc_color(colormap,&(app->fontcolor),TRUE,TRUE);
			}
			

			g_free(readbuf);
		}
		g_io_channel_close(f);
	}
app->home_dir=app->work_dir;
}

void select_bg_color(GObject *o, YNCtx *app)
{
	GdkColor newcolor;

	hildon_color_button_get_color(HILDON_COLOR_BUTTON(o),&newcolor);
	app->color=newcolor;
}

void select_font(GObject *o, YNCtx *app)
{
	g_free(app->fontname);
	app->fontname=g_new0(gchar,strlen(gtk_font_button_get_font_name(GTK_FONT_BUTTON(o)))+1);
	strcpy(app->fontname,gtk_font_button_get_font_name(GTK_FONT_BUTTON(o)));
}

void select_font_color(GObject *o, YNCtx *app)
{
	GdkColor newcolor;

	hildon_color_button_get_color(HILDON_COLOR_BUTTON(o),&newcolor);
	app->fontcolor=newcolor;
}

void set_cairo_transparency(GdkDrawable *drawable, GdkEventExpose *event, GdkColor color, gfloat alpha)
{
	cairo_t *cr;

	cr = gdk_cairo_create (drawable);
	gdk_cairo_region (cr, event->region);
	
	cairo_clip (cr);

	cairo_set_operator (cr, CAIRO_OPERATOR_SOURCE);
	cairo_set_source_rgba (cr, color.red/65535.0, color.green/65535.0, color.blue/65535.0, alpha);
	
	cairo_paint (cr);
  
	cairo_destroy (cr);
}

void build_ui (void)
{ 
	gchar* fullpath;
	fullpath=app->work_dir;
	
	GdkScreen *screen;
    
	app->frame= gtk_frame_new(NULL);
	gtk_container_set_border_width( GTK_CONTAINER( app->frame ), 0);

	app->vbox=gtk_vbox_new (FALSE, 0);
	gtk_container_set_border_width( GTK_CONTAINER( app->vbox ), 0);
    
    app->vbox_fb=gtk_vbox_new (FALSE, 0);
	gtk_container_set_border_width( GTK_CONTAINER( app->vbox ), 0);
    
    app->hbox_toolb=gtk_hbox_new (FALSE, 0);
	gtk_container_set_border_width( GTK_CONTAINER( app->hbox_toolb ), 0);
    
    app->scrolledwindow_fb=GTK_SCROLLED_WINDOW(gtk_scrolled_window_new(NULL,NULL));
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(app->scrolledwindow_fb), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	app->vscroll=gtk_scrolled_window_get_vscrollbar(app->scrolledwindow_fb);
	gtk_widget_set_app_paintable(app->vscroll,TRUE);
	
	 screen = gtk_widget_get_screen (app->frame);
    g_signal_connect(screen, "size-changed", G_CALLBACK(on_orientation_changed),app);
g_signal_connect (app->scrolledwindow_fb, "expose-event", G_CALLBACK (handle_expose),
                           app->scrolledwindow_fb);
g_signal_connect (app->vscroll, "expose-event", G_CALLBACK (handle_expose),
                           app->vscroll);
	
    
	gtk_rc_parse_string(scroll_style);
     
     app->label_evbox=gtk_event_box_new ();
	gtk_event_box_set_visible_window(GTK_EVENT_BOX(app->label_evbox),FALSE);
	g_signal_connect(G_OBJECT(app->label_evbox),"button_release_event",G_CALLBACK(menu),app);
	 
     app->path_label=gtk_label_new (app->work_dir);
	gtk_widget_set_size_request (GTK_WIDGET(app->label_evbox),app->applet_x_size-160,80);
    gtk_label_set_line_wrap (GTK_LABEL (app->path_label),TRUE);
       gtk_label_set_line_wrap_mode (GTK_LABEL (app->path_label), PANGO_WRAP_WORD_CHAR);
        
	gtk_container_add (GTK_CONTAINER (app->label_evbox),app->path_label);
	
	create_table (app);
	/*gtk_widget_set_size_request (GTK_WIDGET(app->hbox_toolb),app->applet_x_size,40);*/
    
    gtk_box_pack_start(GTK_BOX(app->hbox_toolb),app->folder_home_evbox,FALSE,FALSE,0);
    gtk_box_pack_start(GTK_BOX(app->hbox_toolb),app->label_evbox,TRUE,TRUE,0);
    gtk_box_pack_end(GTK_BOX(app->hbox_toolb),app->folder_up_evbox,FALSE,FALSE,0);
    
    gtk_box_pack_end(GTK_BOX(app->vbox),app->vbox_fb/*scrolledwindow_fb*/,TRUE,TRUE,0);
	gtk_box_pack_end(GTK_BOX(app->vbox),app->hbox_toolb,FALSE,FALSE,0);
    gtk_container_add (GTK_CONTAINER (app->vbox_fb), GTK_WIDGET(app->scrolledwindow_fb));
	gtk_container_add( GTK_CONTAINER( app->frame ), app->vbox );
	gtk_widget_show_all (GTK_WIDGET (app->frame));
}


static void deskypplet_plugin_init (DeskYppletPlugin *desktop_plugin)
{
	app = g_new0 (YNCtx, 1);

	load_applet_prefs(app);
	build_ui ();
		
	gtk_container_set_border_width( GTK_CONTAINER( desktop_plugin ), 0);
	gtk_container_add (GTK_CONTAINER (desktop_plugin), app->frame);
	hd_home_plugin_item_set_settings(HD_HOME_PLUGIN_ITEM(desktop_plugin),TRUE);
	gtk_window_resize( GTK_WINDOW (desktop_plugin), app->applet_x_size,app->applet_y_size);
    app->parent=desktop_plugin;
   
} 

static void deskypplet_plugin_class_init (DeskYppletPluginClass *class) 
{
    GtkWidgetClass *widget_class = GTK_WIDGET_CLASS (class);
    widget_class->realize = deskypplet_plugin_realize;
	widget_class->expose_event = deskypplet_plugin_expose_event;
} 

static void deskypplet_plugin_class_finalize (DeskYppletPluginClass *class) {} 

static void deskypplet_plugin_realize (GtkWidget *widget)
{
        GdkScreen *screen;

        screen = gtk_widget_get_screen (widget);
        gtk_widget_set_colormap (widget,gdk_screen_get_rgba_colormap (screen));
        gtk_widget_set_app_paintable (widget,TRUE);

        GTK_WIDGET_CLASS (deskypplet_plugin_parent_class)->realize (widget);
      
}

static gboolean deskypplet_plugin_expose_event(GtkWidget *widget, GdkEventExpose *event)
{
	set_cairo_transparency(GDK_DRAWABLE (widget->window),event,app->color,app->bg_alpha);
	return GTK_WIDGET_CLASS (deskypplet_plugin_parent_class)->expose_event (widget,event);
}

static gboolean handle_expose (GtkWidget *widget, GdkEventExpose *event)
{
  cairo_t *cr;

  cr = gdk_cairo_create (GDK_DRAWABLE (widget->window));
  gdk_cairo_region (cr, event->region);
  cairo_clip (cr);

  cairo_set_operator (cr, CAIRO_OPERATOR_SOURCE);
  cairo_set_source_rgba (cr, (app->color).red, (app->color).green, (app->color).blue, app->bg_alpha);
  cairo_paint (cr);

 
  cairo_destroy (cr);

  return FALSE;
}


static gboolean is_portrait ()
{
  GdkScreen *screen = gdk_screen_get_default();
  int width = gdk_screen_get_width(screen);
  int height = gdk_screen_get_height(screen);
  if (width > height) {
    return FALSE;
  } else {
    return TRUE;
  }
}
 
void on_orientation_changed(GdkScreen *screen, YNCtx *app)
{int i=0;
  if (is_portrait()) {
	  if (app->applet_x_size==800) {app->applet_x_size=720;}
      if (app->applet_y_size==420) {app->applet_y_size=480;}
      i=app->applet_y_size;app->applet_y_size=app->applet_x_size;app->applet_x_size=i;
    gtk_window_resize(GTK_WINDOW(app->parent),app->applet_x_size,app->applet_y_size);
  } 
   else {
	   if (app->applet_y_size==720) {app->applet_y_size=800;}
      if (app->applet_x_size==480) {app->applet_x_size=420;}
      i=app->applet_y_size;app->applet_y_size=app->applet_x_size;app->applet_x_size=i;
    
    gtk_window_resize(GTK_WINDOW(app->parent),app->applet_x_size,app->applet_y_size);
    
  }
  gtk_widget_destroy(app->table);
	create_table (app);
  return;
}

void folder_down (GObject *o,GdkEventButton *event,gchar *fullpath)
{   
	char var [100],value[100],line[200];
	gchar *test;
	char *mime_type [100];
	char *mime_com [100];
	int retval,i;
	DBusConnection *dbus = NULL;
	osso_context_t *osso;
	stat(fullpath, &buf);
	gchar *file_open_txpad=g_strconcat ("txpad ",fullpath,"\0",NULL);
	gchar *file_open;
	
	if(S_ISDIR(buf.st_mode))
      {
	   app->work_dir=fullpath;
       gtk_widget_destroy(app->table);
	   create_table (app);return;
	   }	
    else
      {
	   FILE *fp=fopen("/home/user/.deskypplet/mimehandling.conf","r");
       i=0;
	if (fp) 
      {
	   while (fgets(line,sizeof(line),fp))
          {
	       i++;
           memset (var,0,sizeof(var));
           memset (value,0,sizeof(value));
		   sscanf(line,"%[^'=']=%[^\'#'\n]%*[\t]%*[\t]",var,value);  
		   mime_type [i]=g_strconcat (var,NULL);
		   mime_com [i]=g_strconcat (value,"\0",NULL);
		   test=g_strconcat (mime_type [i],NULL);
		   if(strstr(fullpath,mime_type[i]))
             {
			  file_open=g_strconcat (mime_com[i]," ",fullpath,"\0",NULL);
			  system (file_open);
			  return;
			  }
		   /*printf("%s",file_open)
		   printf ("test %s\n",test);
		   printf ("fullpath %s\n",fullpath);
		   printf ("mime %s\n",var);
		   printf ("com%s\n\n",value);*/
		  }
	   fclose (fp);
	   }
	  		
		}
	   
	   osso = osso_initialize("osso-mime-summon", "0.1", TRUE, NULL);
       if (osso == NULL) 
       {printf("Failed to initialize libosso\n");}
       dbus = (DBusConnection *) osso_get_dbus_connection(osso);
       if (dbus == NULL) 
       {printf("Failed to get dbus connection from osso context\n");}
       retval = hildon_mime_open_file(dbus, fullpath);
	   if (retval != 1) 
	      {
	       printf("Failed to launch hildon_mime_open_file: %d\n", retval);
	       system (file_open_txpad);
	       }
         
	  
	return;
}

void go_folder_up (GObject *o,GdkEventButton *event,YNCtx *app)
{
	char dirpath[1024] = { 0 }; 
    gchar *pointr=NULL;    
    
    pointr = strrchr(app->work_dir,'/');
	size_t n = pointr - app->work_dir + strlen("/") ;
	memcpy(dirpath, app->work_dir, n);
	dirpath[n-1] ='\0';   
    app->work_dir=g_strconcat (dirpath,"\0",NULL);
    if (dirpath[1]==0) {app->work_dir="/";}
 
    gtk_widget_destroy(app->table);
	create_table (app);
   
    return;
}

void go_folder_home (GObject *o,GdkEventButton *event,YNCtx *app)
{
    app->work_dir=app->home_dir;
    
    gtk_widget_destroy(app->table);
	create_table (app);
   
    return;
}

void create_table (YNCtx *app)
{
	char *name_files[350]={0};
	char *name_folders[150]={0};
	char *name[500]={0};
	
	int i=0,j=0,a=0,n_files=0,n_folders=0,n_f=0;
	int table_rows;
	gchar *fullpath=NULL;
	gchar *dirpeg=NULL;
	gchar *dirpeg2=NULL;
	table_rows=(app->applet_x_size/100)-1;
	GtkWidget *label;
    GtkWidget *filebrowser_fb_evbox;
    GtkWidget *filebrowser_fb_img;
/*	gchar *ext=NULL; */   
    FILE *file;
	GdkPixbuf *pixbuf=NULL; 
	
	PangoFontDescription *font_desc = pango_font_description_from_string ("Sans 12"); 
    app->table = gtk_table_new (table_rows,table_rows, FALSE);
    gtk_table_set_row_spacings (GTK_TABLE (app->table), 3);
    gtk_table_set_col_spacings (GTK_TABLE (app->table), 3);


    if((dir=opendir(app->work_dir)) == NULL) {fprintf(stderr,"Error opendir ...\n");return ;}

    while((dirpointer=readdir(dir)) != NULL)
     { 
     if (strcmp((*dirpointer).d_name, ".") != 0 && strcmp((*dirpointer).d_name, "..") != 0)
	  { 
       if (strcmp(app->work_dir, "/") == 0) {fullpath=g_strconcat (app->work_dir, (*dirpointer).d_name,NULL);}
	    else {fullpath=g_strconcat (app->work_dir,"/", (*dirpointer).d_name,NULL);}
	  stat(fullpath, &buf);
      
      if(S_ISDIR(buf.st_mode))
        {
		 name_folders[n_folders]=g_strconcat ((*dirpointer).d_name,NULL);
       /*printf("FOLDER_______________________ %s\n",name_folders [n_folders]);*/
       n_folders++;
       } 
         
       }
     }
     qsort(name_folders, n_folders, sizeof name_folders[0],&myComparisonFunction);
     if(closedir(dir) == -1) {printf("Error closing dir\n");}
      
      
     if((dir=opendir(app->work_dir)) == NULL) {fprintf(stderr,"Error opendir ...\n");return ;}
   
     while((dirpointer=readdir(dir)) != NULL)
     { 
     if (strcmp((*dirpointer).d_name, ".") != 0 && strcmp((*dirpointer).d_name, "..") != 0)
	  { 
       if (strcmp(app->work_dir, "/") == 0) {fullpath=g_strconcat (app->work_dir, (*dirpointer).d_name,NULL);}
	    else {fullpath=g_strconcat (app->work_dir,"/", (*dirpointer).d_name,NULL);}
	  stat(fullpath, &buf);
      
      if(S_ISDIR(buf.st_mode))
        {}
        else
        {
		 name_files[n_files]=g_strconcat ((*dirpointer).d_name,NULL);
      /* printf("File********************************** %s\n",name_files [n_files]);*/
       n_files++;
       } 
         
       }
     }
      if(closedir(dir) == -1) {printf("Error closing dir\n");}
     
      qsort(name_files, n_files, sizeof name_files[0],&myComparisonFunction);
        
    for (a = 0; a < n_folders; a++) 
    {
	 name[n_f]=g_strconcat (name_folders[a],NULL);n_f++;
      	}
     
    for (a = 0; a < n_files; a++) 
    {
	 name[n_f]=g_strconcat (name_files[a],NULL);n_f++;
      	}
    
    for (a = 0; a < n_f; a++) 
       {
       /* printf("data[%d] = \"%s\"\n", a, name[a]);*/
             
	  filebrowser_fb_evbox=gtk_event_box_new ();
	  i++;if (i>table_rows) {i=1;j=j+2;}
	  if (strcmp(app->work_dir, "/") == 0) {fullpath=g_strconcat (app->work_dir, name[a],NULL);}
	    else {fullpath=g_strconcat (app->work_dir,"/", name[a],NULL);}
	  stat(fullpath, &buf);
      /*printf ("%s\n",fullpath);*/
      dirpeg=g_strconcat (fullpath,"/folder.jpg",NULL);
      dirpeg2=g_strconcat (fullpath,"/",name[a],".jpg",NULL);
      if(S_ISDIR(buf.st_mode))
        {
		 file = fopen(dirpeg, "r");
		 if (file)  
           {
			fclose(file);
			pixbuf= gdk_pixbuf_new_from_file_at_size (dirpeg,80,80,NULL);   
		    filebrowser_fb_img=gtk_image_new_from_pixbuf(pixbuf);
            }   
           else 
            { 
			 file = fopen(dirpeg2, "r");
		     if (file)  
               {
			    fclose(file);
			    pixbuf= gdk_pixbuf_new_from_file_at_size (dirpeg2,80,80,NULL);   
		        filebrowser_fb_img=gtk_image_new_from_pixbuf(pixbuf);
                }   
			    else  
       		    {filebrowser_fb_img=gtk_image_new_from_file("/home/user/.deskypplet/icons/folder.png");}
             }
         }
       else if(strstr(name[a],".zip") ||strstr(name[a],".tar") ||strstr(name[a],".gz"))
             {filebrowser_fb_img=gtk_image_new_from_file("/home/user/.deskypplet/icons/packed.png");} 
       else if(strstr(name[a],".txt"))
             {filebrowser_fb_img=gtk_image_new_from_file("/home/user/.deskypplet/icons/txt.png");}
       else if(strstr(name[a],".pdf"))
             {filebrowser_fb_img=gtk_image_new_from_file("/home/user/.deskypplet/icons/pdf.png");}
       else if(strstr(name[a],".py"))
             {filebrowser_fb_img=gtk_image_new_from_file("/home/user/.deskypplet/icons/py.png");}
       else if(strstr(name[a],".sh"))
             {filebrowser_fb_img=gtk_image_new_from_file("/home/user/.deskypplet/icons/sh.png");}
       else if(strstr(name[a],".deb"))
             {filebrowser_fb_img=gtk_image_new_from_file("/home/user/.deskypplet/icons/deb.png");}
       else if(strstr(name[a],".mp3") ||strstr(name[a],".ogg"))
             {filebrowser_fb_img=gtk_image_new_from_file("/home/user/.deskypplet/icons/mp3.png");}
       else
            {
	         if ((pixbuf= gdk_pixbuf_new_from_file_at_size (fullpath,80,80,NULL))==NULL)   
		       {
			    pixbuf=gdk_pixbuf_new_from_file_at_size ("/home/user/.deskypplet/icons/dummy.png",80,80,NULL);
               }
		     filebrowser_fb_img=gtk_image_new_from_pixbuf(pixbuf);
	         }
      
       gtk_container_add (GTK_CONTAINER (filebrowser_fb_evbox),filebrowser_fb_img);
	   	
       label=gtk_label_new (name[a]);
       gtk_widget_modify_font (GTK_WIDGET(label), font_desc);
       gtk_label_set_line_wrap (GTK_LABEL (label),TRUE);
       gtk_label_set_line_wrap_mode (GTK_LABEL (label), PANGO_WRAP_WORD_CHAR);
       gtk_misc_set_alignment(GTK_MISC(label), 0.5f, 0.0f);
       gtk_widget_set_size_request (GTK_WIDGET(label),90,60);
       
       gtk_widget_set_size_request (GTK_WIDGET(filebrowser_fb_img),90,90);
       g_signal_connect(G_OBJECT(filebrowser_fb_evbox),"button_release_event",
                                       G_CALLBACK(folder_down),fullpath);
	
       gtk_event_box_set_visible_window(GTK_EVENT_BOX(filebrowser_fb_evbox),FALSE);
	   
	 
	   gtk_table_attach_defaults (GTK_TABLE (app->table), filebrowser_fb_evbox,i,i+1,j,j+1);
       gtk_table_attach_defaults (GTK_TABLE (app->table), label,i,i+1,j+1,j+2);
    }
     
     app->folder_up_image=gtk_image_new_from_file("./icons/folder_up.png");
	app->folder_up_evbox=gtk_event_box_new ();
	gtk_event_box_set_visible_window(GTK_EVENT_BOX(app->folder_up_evbox),FALSE);
	gtk_container_add (GTK_CONTAINER (app->folder_up_evbox),app->folder_up_image);
	g_signal_connect(G_OBJECT(app->folder_up_evbox),"button_release_event",G_CALLBACK(go_folder_up),app);
	
	 app->folder_home_image=gtk_image_new_from_file("./icons/folder_home.png");
	app->folder_home_evbox=gtk_event_box_new ();
	gtk_event_box_set_visible_window(GTK_EVENT_BOX(app->folder_home_evbox),FALSE);
	gtk_container_add (GTK_CONTAINER (app->folder_home_evbox),app->folder_home_image);
	g_signal_connect(G_OBJECT(app->folder_home_evbox),"button_release_event",G_CALLBACK(go_folder_home),app);
	
	g_signal_connect (app->table, "expose-event", G_CALLBACK (handle_expose),app->table);
    
  /* g_signal_connect (app->path_label, "expose-event", G_CALLBACK (set_cairo_transparency),app->path_label);
    */
      
   	 gtk_widget_set_size_request (GTK_WIDGET(app->label_evbox),app->applet_x_size-160,80);
    gtk_label_set_text (GTK_LABEL (app->path_label),app->work_dir);
   	 
     gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (app->scrolledwindow_fb), app->table);
   	 gtk_widget_show_all (GTK_WIDGET (app->frame));
   	 pango_font_description_free (font_desc);
   	   
  return;
}

int myComparisonFunction(const void *x, const void *y) 
{
  return (strcmp(*(const char **)x, *(const char **)y));
}

void menu ()
{
	gchar *com_do=NULL;
	gchar *fullpath=NULL;
	char var [100],value[100],line[200];
	int i=0;
	GtkWidget *vbox=NULL;
	GtkWidget *hbox=NULL;
	GtkWidget *button=NULL;
	GtkWidget *button_term=NULL;
	GtkWidget *button_fav=NULL;
	GtkWidget *pannable_area=NULL;
    GtkWidget *table=NULL;
	GtkWidget *label=NULL;
	
	gchar *title;
	gchar *title_capa;
	gchar *title_free;
	title_capa=g_get_capacity (app->work_dir);
	title_free=g_get_free_space (app->work_dir);
	title=g_strconcat ("free ",title_free," / ",title_capa,"\0",NULL);
	
	dialog=gtk_dialog_new_with_buttons(title,NULL, 0,0,0,0,0,NULL);
	gtk_widget_set_size_request (GTK_WIDGET(dialog),-1,800); 
    
    hbox=gtk_hbox_new(TRUE,0);
	vbox=gtk_vbox_new(TRUE,0);
	
	pannable_area = hildon_pannable_area_new ();
	/*gtk_widget_set_size_request (GTK_WIDGET(pannable_area),app->applet_x_size-20,-1); 
    */
	table = gtk_table_new (40,2, FALSE);
    gtk_table_set_row_spacings (GTK_TABLE (table), 2);
    gtk_table_set_col_spacings (GTK_TABLE (table), 2);
    
    FILE *fp=fopen("/home/user/.deskypplet/ypplet-bookmarks.conf","r");
	if (fp) 
      {
	   while (fgets(line,sizeof(line),fp))
          {
	       /*sscanf(line, "%[^\n]\n", value);
	        printf ("line %s\n",line);printf ("%s\n",value);*/
	       i++;
          memset (var,0,sizeof(var));
           memset (value,0,sizeof(value));
		    sscanf(line,"%[^'=']=%[^\'#'\n]%*[\t]%*[\t]",var,value);  
			
           button = hildon_button_new_with_text (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT,
		    				       HILDON_BUTTON_ARRANGEMENT_HORIZONTAL, 0,0);
		   fullpath=g_strconcat (value,"\0",NULL);
		   if (fullpath==NULL){fullpath="/home/user";}
	       label=gtk_label_new (var);
	       printf ("\n%s\n",var);
			  printf ("%s\n",value);
	       /*gtk_widget_set_size_request (GTK_WIDGET(label),app->applet_x_size-30,-1); 
    */
	       gtk_label_set_line_wrap (GTK_LABEL (label),TRUE);
           gtk_label_set_line_wrap_mode (GTK_LABEL (label), PANGO_WRAP_WORD_CHAR);
           gtk_misc_set_alignment(GTK_MISC(label), 0.0f, 0.5f);
       
	       gtk_container_add (GTK_CONTAINER (button), label);
	       g_signal_connect (button, "clicked", G_CALLBACK (bookmark),fullpath);
            
           gtk_table_attach_defaults (GTK_TABLE (table), button,2,3,i,i+1);
           }
	   fclose (fp);
	   }
	i=2;
	fp=fopen("/home/user/.deskypplet/yppletactions.conf","r");
	if (fp) 
      {
	   while (fgets(line,sizeof(line),fp))
          {
	       i++;
	      /* memset (var,0,sizeof(var));
           memset (value,0,sizeof(value));*/
		    sscanf(line,"%[^'=']=%[^\'#'\n]%*[\t]%*[\t]",var,value);  
			 /* printf ("\n%s\n",var);
			  printf ("%s\n",value);
			  */
			  com_do=g_strconcat (value,"\0",NULL);
   /* printf ("%s\n",com_do);*/
			 button = hildon_button_new_with_text (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT,
						       HILDON_BUTTON_ARRANGEMENT_VERTICAL, var,0);
	  g_signal_connect (button, "clicked", G_CALLBACK (custom_com),com_do);
      gtk_button_set_alignment (GTK_BUTTON(button),0,0.5);				       
	  
            gtk_table_attach_defaults (GTK_TABLE (table), button,1,2,i,i+1);
          
            }
	   fclose (fp);
	   }
	
	button_term = hildon_button_new_with_text (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT,
	                				       HILDON_BUTTON_ARRANGEMENT_VERTICAL,"Terminal here",NULL);
	g_signal_connect (button_term, "clicked", G_CALLBACK (term_her),NULL);
    gtk_button_set_alignment (GTK_BUTTON(button_term),0,0.5);				       
	gtk_table_attach_defaults (GTK_TABLE (table), button_term,1,2,1,2);  
	
	button_fav = hildon_button_new_with_text (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT,
	                				       HILDON_BUTTON_ARRANGEMENT_VERTICAL,"Bookmark folder",NULL);
	g_signal_connect (button_fav, "clicked", G_CALLBACK (book_this),NULL);
    gtk_button_set_alignment (GTK_BUTTON(button_fav),0,0.5);				       
	gtk_table_attach_defaults (GTK_TABLE (table), button_fav,1,2,2,3);     
	
	hildon_pannable_area_add_with_viewport (HILDON_PANNABLE_AREA (pannable_area),table);
    gtk_container_add (GTK_CONTAINER (hbox), pannable_area);
    
    gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->vbox),hbox);
	
	gtk_widget_show_all(dialog);
	gtk_dialog_run (GTK_DIALOG(dialog));
	
	return;
}

void bookmark (gpointer button,gchar *fullpath)
{   /*printf ("%s\n",fullpath);
	app->work_dir=g_strconcat (hildon_button_get_title(button),"\0",NULL);*/
    app->work_dir=fullpath;
    gtk_widget_destroy(dialog);
	gtk_widget_destroy(app->table);
	create_table (app);
   	
    return;
}

void custom_com (gpointer button,gchar *com_do)
{   
	com_com=g_strconcat (com_do,app->work_dir,"\" & ","\0",NULL);
	system (com_com);
	/*printf ("com_com %s",com_com);*/
    gtk_widget_destroy(dialog);
	return;
}

void term_her ()
{   
	FILE *f=NULL;

	f=fopen("/home/user/.deskypplet/deskypplet-terminal","w");
	if(f!=NULL)
	{
		fprintf(f,"#!/bin/sh\n");
		fprintf(f,"cd %s \n",app->work_dir);
		fprintf(f,"/bin/sh\n");
		fclose(f);
	}
	system ("chmod +x /home/user/.deskypplet/deskypplet-terminal &");
	
	system ("osso-xterm /home/user/.deskypplet/deskypplet-terminal &");
	gtk_widget_destroy(dialog);
	return;
}

void book_this ()
{   gchar *fullpath;
	char line[150],value[150];
	char *bookm[150];
	int i=0,j=0;
	FILE *fp=fopen("/home/user/.deskypplet/ypplet-bookmarks.conf","r");
	if (fp) 
      {
	   while (fgets(line,sizeof(line),fp))
          {
	       /*printf ("xxline %s\n",line);*/
	       sscanf(line, "%[^\n]\n", value);
	       bookm[i]=g_strconcat (value,"\0",NULL);
	       i++;
           }
	   fclose (fp);
	   }
	   fullpath=g_strconcat (app->work_dir,"=",app->work_dir,"\0",NULL);
	
	   /*printf ("oooxline %s\n",fullpath);
	   printf ("1line %s\n",bookm [1]);
	   hildon_banner_show_information(NULL, NULL, "Bookmark added to list");*/
	 
	fp=fopen("/home/user/.deskypplet/ypplet-bookmarks.conf","w");
	if(fp!=NULL)
	  {
		for (j = 0; j < i; j++) 
        {
		fprintf(fp,"%s\n",bookm[j]);
		}
		fprintf(fp,"%s\n",fullpath);
		fclose(fp);
		hildon_banner_show_information(NULL, NULL, "Bookmark added to list");   
	   }
	gtk_widget_destroy(dialog);
	return;
}

void do_it (void)
{
	/*gchar *com_do=NULL;
	gchar *fullpath=NULL;
	char *name_files[350]={0};
	int n_files=0:
	char var [50],value[100],line[150];
	int i=0;
	
	if((dir=opendir(app->work_dir)) == NULL) {fprintf(stderr,"Error opendir ...\n");return ;}
   
     while((dirpointer=readdir(dir)) != NULL)
     { 
     if (strcmp((*dirpointer).d_name, ".") != 0 && strcmp((*dirpointer).d_name, "..") != 0)
	  { 
       if (strcmp(app->work_dir, "/") == 0) {fullpath=g_strconcat (app->work_dir, (*dirpointer).d_name,NULL);}
	    else {fullpath=g_strconcat (app->work_dir,"/", (*dirpointer).d_name,NULL);}
	  stat(fullpath, &buf);
      
      if(S_ISDIR(buf.st_mode))
        {}
        else
        {
		 name_files[n_files]=g_strconcat ((*dirpointer).d_name,NULL);
       printf("File********************************** %s\n",name_files [n_files]);
       n_files++;
       } 
         
       }
     }
      if(closedir(dir) == -1) {printf("Error closing dir\n");}
     
      qsort(name_files, n_files, sizeof name_files[0],&myComparisonFunction);
  
	   
	FILE *f=NULL;

	f=fopen("/home/user/.deskypplet/deskypplet-terminal","w");
	if(f!=NULL)
	{
		fprintf(f,"#!/bin/sh\n");
		fprintf(f,"cd %s \n",app->work_dir);
		fprintf(f,"/bin/sh\n");
		fclose(f);
	}
	
	system ("osso-xterm /home/user/.deskypplet/deskypplet-terminal &");
	gtk_widget_destroy(dialog);
	
	return;*/
	}




gchar *g_get_capacity ( gchar * dev_path)
{
	unsigned long long result = 0;
	int n;
	gchar s_cap[50];
	gchar * ss_cap = "N/A";
	struct statvfs sfs;
	if ( statvfs ( dev_path, &sfs) != -1 )
	{
		result = (unsigned long long)sfs.f_bsize * sfs.f_blocks;
	}
	if (result > 0)
	{
		double f_cap = (double)result/(1024*1024*1024);
		n = sprintf(s_cap, "%.3f Gb", f_cap);
		ss_cap = g_strdup(s_cap);
	}
	return ss_cap;
}

gchar *g_get_free_space ( gchar * dev_path)
{
	unsigned long long result = 0;
	int n;
	gchar s_cap[50];
	gchar * ss_cap = "N/A";
	struct statvfs sfs;
	if ( statvfs ( dev_path, &sfs) != -1 )
	{
		result = (unsigned long long)sfs.f_bsize * sfs.f_bfree;
	}
	if (result > 0)
	{
		double f_cap = (double)result/(1024*1024*1024);
		n = sprintf(s_cap, "%.3f Gb", f_cap);
		ss_cap = g_strdup(s_cap);
	}
	return ss_cap;
}

/*new:
 add bookmark button
 bookmarks file format changed 
 Size in partition left in menu title
 
to do:
portrait adjust not fullscreen
execute edit sh
unset pixbuf
.TXT .txt icons bug
*/
