#include "abstractplaylistlistmodel.h"
#ifndef QML_USER_INTERFACE
#include "thumbnailcache.h"
#endif

AbstractPlaylistListModel::AbstractPlaylistListModel(QObject *parent) :
    QAbstractListModel(parent)
  #ifndef QML_USER_INTERFACE
    ,m_cache(new ThumbnailCache)
  #endif
{
    m_roleNames[IdRole] = "id";
    m_roleNames[PlaylistIdRole] = "playlistId";
    m_roleNames[TitleRole] = "title";
    m_roleNames[ArtistRole] = "artist";
    m_roleNames[ArtistAvatarUrlRole] = "artistAvatarUrl";
    m_roleNames[DateRole] = "date";
    m_roleNames[VideoCountRole] = "videoCount";
#ifndef QML_USER_INTERFACE
    m_roleNames[ThumbnailRole] = "thumbnail";
#endif
    m_roleNames[ThumbnailUrlRole] = "thumbnailUrl";
    m_roleNames[LargeThumbnailUrlRole] = "largeThumbnailUrl";
    m_roleNames[DescriptionRole] = "description";
    m_roleNames[ServiceRole] = "service";
#if QT_VERSION < 0x050000
    this->setRoleNames(m_roleNames);
#endif

#ifndef QML_USER_INTERFACE
    this->connect(m_cache, SIGNAL(thumbnailReady()), this, SLOT(onThumbnailReady()));
#endif
}

AbstractPlaylistListModel::~AbstractPlaylistListModel() {
    m_list.clear();
#ifndef QML_USER_INTERFACE
    delete m_cache;
    m_cache = 0;
#endif
}

#if QT_VERSION >= 0x050000
QHash<int, QByteArray> AbstractPlaylistListModel::roleNames() const {
    return m_roleNames;
}
#endif

void AbstractPlaylistListModel::clear() {
    this->beginResetModel();
    m_list.clear();
    this->endResetModel();
}

int AbstractPlaylistListModel::rowCount(const QModelIndex &parent) const {
    Q_UNUSED(parent)

    return m_list.size();
}

QVariant AbstractPlaylistListModel::data(const QModelIndex &index, int role) const {
    switch (role) {
    case IdRole:
        return m_list.at(index.row()).data()->id();
    case PlaylistIdRole:
        return m_list.at(index.row()).data()->playlistId();
    case TitleRole:
        return m_list.at(index.row()).data()->title();
    case ArtistRole:
        return m_list.at(index.row()).data()->artist();
    case ArtistAvatarUrlRole:
        return m_list.at(index.row()).data()->artistAvatarUrl();
    case DateRole:
        return m_list.at(index.row()).data()->date();
    case VideoCountRole:
        return m_list.at(index.row()).data()->videoCount();
#ifndef QML_USER_INTERFACE
    case ThumbnailRole:
        return m_cache->thumbnail(m_list.at(index.row()).data()->thumbnailUrl(), QSize(120, 90));
#endif
    case ThumbnailUrlRole:
        return m_list.at(index.row()).data()->thumbnailUrl();
    case LargeThumbnailUrlRole:
        return m_list.at(index.row()).data()->largeThumbnailUrl();
    case DescriptionRole:
        return m_list.at(index.row()).data()->description();
    case ServiceRole:
        return m_list.at(index.row()).data()->service();
    default:
        return QVariant();
    }
}

QVariant AbstractPlaylistListModel::data(int row, const QByteArray &role) const {
    return this->data(this->index(row), this->roleNames().key(role));
}

QSharedPointer<PlaylistItem> AbstractPlaylistListModel::get(int row) const {
    if ((row >= 0) && (row < m_list.size())) {
        return QSharedPointer<PlaylistItem>(m_list.at(row));
    }

    return QSharedPointer<PlaylistItem>();
}

#ifdef QML_USER_INTERFACE
PlaylistItem* AbstractPlaylistListModel::getFromQML(int row) const {
    if ((row >= 0) && (row < m_list.size())) {
        return m_list.at(row).data();
    }

    return 0;
}
#endif

void AbstractPlaylistListModel::insertPlaylist(int row, QSharedPointer<PlaylistItem> playlist) {
    this->beginInsertRows(QModelIndex(), row, row);
    m_list.insert(row, playlist);
    this->endInsertRows();
}

void AbstractPlaylistListModel::appendPlaylist(QSharedPointer<PlaylistItem> playlist) {
    this->beginInsertRows(QModelIndex(), this->rowCount(), this->rowCount());
    m_list.append(playlist);
    this->endInsertRows();
}

bool AbstractPlaylistListModel::removePlaylist(const QVariant &value, int role) {
    QModelIndexList indexes = this->match(this->index(0), role, value, 1, Qt::MatchExactly);

    if (indexes.isEmpty()) {
        return false;
    }

    return this->removeRow(indexes.first().row());
}

bool AbstractPlaylistListModel::removeRow(int row, const QModelIndex &parent)
{
    Q_UNUSED(parent)

    if ((row >= 0) && (row < m_list.size())) {
        this->beginRemoveRows(QModelIndex(), row, row);
        m_list.takeAt(row).clear();
        this->endRemoveRows();

        return true;
    }

    return false;
}

#ifndef QML_USER_INTERFACE
void AbstractPlaylistListModel::onThumbnailReady() {
    emit dataChanged(this->index(0), this->index(this->rowCount() - 1));
}
#endif
