#include "youtubeuploaddialog.h"
#include "../base/transfermanager.h"
#include "../base/settings.h"
#include "youtubeuploadcategoryselector.h"
#include <QLineEdit>
#include <QTextEdit>
#include <QPushButton>
#include <QCheckBox>
#include <QDialogButtonBox>
#include <QScrollArea>
#include <QGridLayout>
#include <QLabel>
#include <QFileDialog>

YouTubeUploadDialog::YouTubeUploadDialog(QWidget *parent) :
    AbstractDialog(parent),
    m_fileSelector(new QMaemo5ValueButton(tr("Video file"), this)),
    m_titleEdit(new QLineEdit(this)),
    m_descriptionEdit(new QTextEdit(this)),
    m_tagsEdit(new QLineEdit(this)),
    m_categorySelector(new YouTubeUploadCategorySelector(tr("Category"), this)),
    m_privateCheckbox(new QCheckBox(tr("Private?"), this)),
    m_buttonBox(new QDialogButtonBox(Qt::Vertical, this)),
    m_doneButton(m_buttonBox->addButton(tr("Done"), QDialogButtonBox::AcceptRole)),
    m_scrollArea(new QScrollArea(this)),
    m_grid(new QGridLayout(this))
{
    this->setWindowTitle(tr("Upload video"));

    QLabel *titleLabel = new QLabel(tr("Title"), this);
    QLabel *descriptionLabel = new QLabel(tr("Description"), this);
    QLabel *tagsLabel = new QLabel(tr("Tags"), this);
    QWidget *scrollWidget = new QWidget(m_scrollArea);
    QVBoxLayout *vbox = new QVBoxLayout(scrollWidget);

    vbox->addWidget(m_fileSelector);
    vbox->addWidget(titleLabel);
    vbox->addWidget(m_titleEdit);
    vbox->addWidget(descriptionLabel);
    vbox->addWidget(m_descriptionEdit);
    vbox->addWidget(tagsLabel);
    vbox->addWidget(m_tagsEdit);
    vbox->addWidget(m_categorySelector);
    vbox->addWidget(m_privateCheckbox);

    m_scrollArea->setWidgetResizable(true);
    m_scrollArea->setWidget(scrollWidget);
    m_doneButton->setEnabled(false);
    m_descriptionEdit->setAcceptRichText(false);
    m_fileSelector->setValueText(tr("None chosen"));
    m_categorySelector->setValue("Entertainment");

    this->connect(m_titleEdit, SIGNAL(textChanged(QString)), this, SLOT(onTitleTextChanged(QString)));
    this->connect(m_buttonBox, SIGNAL(accepted()), this, SLOT(uploadVideo()));
    this->connect(m_fileSelector, SIGNAL(clicked()), this, SLOT(setVideoFile()));

    this->onOrientationChanged();
}

void YouTubeUploadDialog::setLandscapeLayout() {
    this->setFixedHeight(340);
    m_buttonBox->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_scrollArea, 0, 0);
        m_grid->addWidget(m_buttonBox, 0, 1, Qt::AlignBottom);
    }
    else {
        m_grid->removeWidget(m_buttonBox);
        m_grid->addWidget(m_buttonBox, 0, 1, Qt::AlignBottom);
    }
}

void YouTubeUploadDialog::setPortraitLayout() {
    this->setFixedHeight(600);
    m_buttonBox->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_scrollArea, 0, 0);
        m_grid->addWidget(m_buttonBox, 1, 0, Qt::AlignBottom);
    }
    else {
        m_grid->removeWidget(m_buttonBox);
        m_grid->addWidget(m_buttonBox, 1, 0, Qt::AlignBottom);
    }
}

void YouTubeUploadDialog::setVideoFile() {
    QString filePath = QFileDialog::getOpenFileName(this, tr("Video file"), "/home/user/MyDocs", tr("Video Files (*.avi *.divx *.flv *.mp4 *.mkv *.mpg *.mpeg *.wmv *.xvid)"));

    if (!filePath.isEmpty()) {
        m_metadata.insert("filePath", filePath);

        QString fileName = filePath.section('/', -1);
        m_fileSelector->setValueText(fileName);
        m_titleEdit->setText(fileName.section('.', 0, -2));
    }
}

void YouTubeUploadDialog::onTitleTextChanged(const QString &text) {
    m_doneButton->setEnabled(!text.isEmpty());
}

void YouTubeUploadDialog::uploadVideo() {
    m_metadata.insert("title", m_titleEdit->text());
    m_metadata.insert("description", m_descriptionEdit->toPlainText());
    m_metadata.insert("tags", m_tagsEdit->text());
    m_metadata.insert("category", m_categorySelector->currentValue());
    m_metadata.insert("isPrivate", m_privateCheckbox->isChecked());
    m_metadata.insert("uploadAttribute", Settings::instance()->uploadAttribute());

    TransferManager::instance()->addUploadTransfer(m_metadata);
    this->accept();
}
