#include "dailymotioncommentdialog.h"
#include "../base/dailymotion.h"
#include <QTextEdit>
#include <QPushButton>
#include <QDialogButtonBox>
#include <QGridLayout>
#include <QScrollArea>
#include <QLabel>

DailymotionCommentDialog::DailymotionCommentDialog(QSharedPointer<VideoItem> video, QWidget *parent) :
    AbstractDialog(parent),
    m_video(video),
    m_commentEdit(new QTextEdit(this)),
    m_buttonBox(new QDialogButtonBox(Qt::Vertical, this)),
    m_doneButton(m_buttonBox->addButton(tr("Done"), QDialogButtonBox::AcceptRole)),
    m_scrollArea(new QScrollArea(this)),
    m_grid(new QGridLayout(this))
{
    this->setWindowTitle(tr("Add comment"));

    QLabel *label = new QLabel(tr("Your comment"), this);
    QWidget *scrollWidget = new QWidget(m_scrollArea);
    QVBoxLayout *vbox = new QVBoxLayout(scrollWidget);

    vbox->addWidget(label);
    vbox->addWidget(m_commentEdit);

    m_scrollArea->setWidgetResizable(true);
    m_scrollArea->setWidget(scrollWidget);
    m_scrollArea->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    m_doneButton->setEnabled(false);

    this->connect(m_commentEdit, SIGNAL(textChanged()), this, SLOT(onCommentTextChanged()));
    this->connect(m_buttonBox, SIGNAL(accepted()), this, SLOT(submitComment()));

    this->onOrientationChanged();
}

void DailymotionCommentDialog::setLandscapeLayout() {
    this->setFixedHeight(340);
    m_buttonBox->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_scrollArea, 0, 0);
        m_grid->addWidget(m_buttonBox, 0, 1, Qt::AlignBottom);
    }
    else {
        m_grid->removeWidget(m_buttonBox);
        m_grid->addWidget(m_buttonBox, 0, 1, Qt::AlignBottom);
    }
}

void DailymotionCommentDialog::setPortraitLayout() {
    this->setFixedHeight(600);
    m_buttonBox->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_scrollArea, 0, 0);
        m_grid->addWidget(m_buttonBox, 1, 0, Qt::AlignBottom);
    }
    else {
        m_grid->removeWidget(m_buttonBox);
        m_grid->addWidget(m_buttonBox, 1, 0, Qt::AlignBottom);
    }
}

void DailymotionCommentDialog::onCommentTextChanged() {
    m_doneButton->setEnabled(!m_commentEdit->toPlainText().isEmpty());
}

void DailymotionCommentDialog::submitComment() {
    QVariantMap comment;
    comment.insert("videoId", m_video.data()->videoId());
    comment.insert("body", m_commentEdit->toPlainText());

    Dailymotion::instance()->addComment(comment);

    this->accept();
}
