#ifndef FEEDURLS_H
#define FEEDURLS_H

#include <QUrl>

//YouTube Feeds

const QString YOUTUBE_VIDEOS_BASE_URL("https://gdata.youtube.com/feeds/api/videos");
const QString YOUTUBE_USERS_BASE_URL("https://gdata.youtube.com/feeds/api/users");
const QString YOUTUBE_CHANNELS_BASE_URL("https://gdata.youtube.com/feeds/api/channels");
const QString YOUTUBE_PLAYLISTS_BASE_URL("https://gdata.youtube.com/feeds/api/playlists");
const QString YOUTUBE_PLAYLISTS_SEARCH_BASE_URL("https://gdata.youtube.com/feeds/api/playlists/snippets");
const QString YOUTUBE_STANDARD_FEEDS_BASE_URL("https://gdata.youtube.com/feeds/api/standardfeeds/");

const QUrl YOUTUBE_UPLOADS_FEED("https://gdata.youtube.com/feeds/api/users/default/uploads?v=2.1&max-results=30");
const QUrl YOUTUBE_FAVOURITES_FEED("https://gdata.youtube.com/feeds/api/users/default/favorites?v=2.1&max-results=30");
const QUrl YOUTUBE_RECOMMENDED_FEED("https://gdata.youtube.com/feeds/api/users/default/recommendations?v=2.1&max-results=30");
const QUrl YOUTUBE_PLAYLISTS_FEED("https://gdata.youtube.com/feeds/api/users/default/playlists?v=2.1&max-results=50");
const QUrl YOUTUBE_SUBSCRIPTIONS_FEED("https://gdata.youtube.com/feeds/api/users/default/subscriptions?v=2.1&max-results=50");
const QUrl YOUTUBE_NEW_SUBSCRIPTION_VIDEOS_FEED("https://gdata.youtube.com/feeds/api/users/default/newsubscriptionvideos?v=2.1&max-results=30");
const QUrl YOUTUBE_WATCH_HISTORY_FEED("https://gdata.youtube.com/feeds/api/users/default/watch_history?v=2.1&max-results=30");
const QUrl YOUTUBE_WATCH_LATER_FEED("https://gdata.youtube.com/feeds/api/users/default/watch_later?v=2.1&max-results=50");

const QString YOUTUBE_SINGLE_PLAYLIST_FIELDS("id,title,summary,published,yt:countHint,author(name,yt:userId),media:group(media:thumbnail[@yt:name='default']),yt:playlistId");
const QString YOUTUBE_SINGLE_VIDEO_FIELDS("id,category[@scheme='http://gdata.youtube.com/schemas/2007/keywords.cat'],media:group(media:title,media:thumbnail[@yt:name='default'or@yt:name='hqdefault'],media:description,media:player[@url],media:credit,yt:duration,yt:uploaded,yt:uploaderId,yt:videoid),yt:statistics,yt:rating");
const QString YOUTUBE_VIDEO_FIELDS("link[@rel='next'],openSearch:totalResults,entry(id,category[@scheme='http://gdata.youtube.com/schemas/2007/keywords.cat'],media:group(media:title,media:thumbnail[@yt:name='default'or@yt:name='hqdefault'],media:description,media:player[@url],media:credit,yt:duration,yt:uploaded,yt:uploaderId,yt:videoid),yt:statistics,yt:rating)");
const QString YOUTUBE_PLAYLIST_FIELDS("link[@rel='next'],openSearch:totalResults,entry(id,title,summary,published,yt:countHint,author(name,yt:userId),media:group(media:thumbnail[@yt:name='default']),yt:playlistId)");
const QString YOUTUBE_SINGLE_COMMENT_FIELDS("id,content,published,link[@rel!='related'and@rel!='alternate'and@rel!='self'and@rel!='edit'],yt:videoid,author(name,yt:userId)");
const QString YOUTUBE_COMMENT_FIELDS("link[@rel='next'],openSearch:totalResults,entry(id,content,published,link[@rel!='related'and@rel!='alternate'and@rel!='self'and@rel!='edit'],yt:videoid,author(name,yt:userId))");
const QString YOUTUBE_USER_FIELDS("link[@rel='next'],openSearch:totalResults,entry(id,title,author(name,yt:userId))");
const QString YOUTUBE_SUBSCRIPTION_FIELDS("link[@rel='next'],openSearch:totalResults,entry(id,title,yt:username,media:thumbnail,yt:channelId)");
const QString YOUTUBE_USER_PROFILE_FIELDS("id,title,summary,author,gd:feedLink[@rel='http://gdata.youtube.com/schemas/2007#user.uploads'],link[@rel='related'],yt:statistics,yt:userId,yt:username,yt:age,yt:gender,yt:location,media:thumbnail,yt:incomplete");

//Dailymotion Feeds

const QString DAILYMOTION_VIDEOS_BASE_URL("https://api.dailymotion.com/videos");
const QString DAILYMOTION_USERS_BASE_URL("https://api.dailymotion.com/users");
const QString DAILYMOTION_PLAYLISTS_BASE_URL("https://api.dailymotion.com/playlists");
const QString DAILYMOTION_GROUPS_BASE_URL("https://api.dailymotion.com/groups");

const QUrl DAILYMOTION_UPLOADS_FEED("https://api.dailymotion.com/me/videos?limit=30");
const QUrl DAILYMOTION_FAVOURITES_FEED("https://api.dailymotion.com/me/favorites?limit=30");
const QUrl DAILYMOTION_PLAYLISTS_FEED("https://api.dailymotion.com/me/playlists?limit=100");
const QUrl DAILYMOTION_GROUPS_FEED("https://api.dailymotion.com/me/groups?limit=30");
const QUrl DAILYMOTION_SUBSCRIPTIONS_FEED("https://api.dailymotion.com/me/following?limit=100");
const QUrl DAILYMOTION_NEW_SUBSCRIPTION_VIDEOS_FEED("https://api.dailymotion.com/me/subscriptions?limit=30");

const QString DAILYMOTION_VIDEO_FIELDS("created_time,description,duration,id,owner.username,owner.id,owner.avatar_medium_url,private,rating,ratings_total,tags,thumbnail_medium_url,thumbnail_large_url,title,url,views_total");
const QString DAILYMOTION_PLAYLIST_FIELDS("created_time,description,id,name,owner.username,owner.id,owner.avatar_medium_url");
const QString DAILYMOTION_GROUP_FIELDS("created_time,description,id,name,owner.username,owner.id,owner.avatar_medium_url");
const QString DAILYMOTION_COMMENT_FIELDS("created_time,id,message,owner.username,owner.id,owner.avatar_medium_url,video.id");
const QString DAILYMOTION_USER_FIELDS("avatar_medium_url,id,username,screenname");
const QString DAILYMOTION_USER_PROFILE_FIELDS("avatar_medium_url,description,id,username,screenname,videos_total,gender,views_total");
const QString DAILYMOTION_VIDEO_METADATA_FIELDS("title,description,tags,private,allow_comments,channel,id");

//Vimeo Feeds

const QString VIMEO_BASE_URL("http://vimeo.com/api/rest/v2");
const QUrl VIMEO_UPLOADS_FEED("http://vimeo.com/api/rest/v2?method=vimeo.videos.getUploaded&sort=newest&per_page=30&full_response=true");
const QUrl VIMEO_LIKES_FEED("http://vimeo.com/api/rest/v2?method=vimeo.videos.getLikes&sort=newest&per_page=30&full_response=true");
const QUrl VIMEO_ALBUMS_FEED("http://vimeo.com/api/rest/v2?method=vimeo.albums.getAll&sort=newest&per_page=50");
const QUrl VIMEO_GROUPS_FEED("http://vimeo.com/api/rest/v2?method=vimeo.groups.getAll&sort=newest&per_page=50");
const QUrl VIMEO_SUBSCRIPTIONS_FEED("http://vimeo.com/api/rest/v2?method=vimeo.contacts.getAll&sort=newest&per_page=50");
const QUrl VIMEO_NEW_SUBSCRIPTION_VIDEOS_FEED("http://vimeo.com/api/rest/v2?method=vimeo.videos.getSubscriptions&per_page=30&full_response=true");
const QUrl VIMEO_WATCH_LATER_FEED("http://vimeo.com/api/rest/v2?method=vimeo.albums.getWatchLater&per_page=30&full_response=true");

#endif // FEEDURLS_H
