#ifndef ABSTRACTVIDEOLISTMODEL_H
#define ABSTRACTVIDEOLISTMODEL_H

#include "videoitem.h"
#include <QAbstractListModel>
#include <QSharedPointer>

#ifndef QML_USER_INTERFACE
class ThumbnailCache;
#endif

class AbstractVideoListModel : public QAbstractListModel
{
    Q_OBJECT

public:
    enum Roles {
        IdRole = Qt::UserRole + 1,
        VideoIdRole,
        FavouriteIdRole,
        PlaylistVideoIdRole,
        TitleRole,
        ArtistRole,
        DateRole,
        DurationRole,
        ViewCountRole,
        LikesRole,
        DislikesRole,
        RatingCountRole,
        RatingRole,
#ifndef QML_USER_INTERFACE
        ThumbnailRole,
        ThumbnailPressedRole,
#endif
        ThumbnailUrlRole,
        ArchiveRole,
        ServiceRole,
        FavouriteRole,
        SelectedRole
    };

public:
    explicit AbstractVideoListModel(QObject *parent = 0);
    ~AbstractVideoListModel();
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role) const;
    Q_INVOKABLE QVariant data(int row, const QByteArray &role) const;
#ifndef QML_USER_INTERFACE
    bool setData(const QModelIndex &index, const QVariant &value, int role);
#endif
    QSharedPointer<VideoItem> get(int row) const;
#ifdef QML_USER_INTERFACE
    Q_INVOKABLE VideoItem* getFromQML(int row) const;
#endif
    Q_INVOKABLE QList<int> selectedRows() const { return m_selectedRows; }
    QList< QSharedPointer<VideoItem> > selectedItems() const;
#ifdef QML_USER_INTERFACE
    Q_INVOKABLE QList<VideoItem*> selectedItemsFromQML() const;
#endif
    inline bool itemsSelected() const { return !this->selectedRows().isEmpty(); }

public slots:
    void clear();
    void selectAll();
    void selectNone();
    void toggleSelected(int row);
    void insertVideo(int row, QSharedPointer<VideoItem> video);
    void appendVideo(QSharedPointer<VideoItem> video);
    bool removeVideo(const QVariant &value, int role = VideoIdRole);

protected:
    bool removeRow(int row, const QModelIndex &parent = QModelIndex());

#ifndef QML_USER_INTERFACE
protected slots:
    void onThumbnailReady();
#endif
    
protected:
#ifndef QML_USER_INTERFACE
    ThumbnailCache *m_cache;
    int m_thumbnailPressedRow;
#endif
    QList< QSharedPointer<VideoItem> > m_list;
    QList<int> m_selectedRows;
};

#endif // ABSTRACTVIDEOLISTMODEL_H
