#ifndef WINDOWSTACK_H
#define WINDOWSTACK_H

#include <QObject>

class WindowStack : public QObject
{
    Q_OBJECT

public:
    explicit WindowStack(QObject *parent = 0);
    QWidget* currentWindow() const;
    QWidget* rootWindow() const;

    static WindowStack* instance();
        
public slots:
    void addWindowToStack(QWidget *window);
    void removeWindowFromStack(QObject *window);
    void unwindWindowStack();
    
private:
    QList<QWidget*> m_windowStack;
};

#endif // WINDOWSTACK_H
