#ifndef USERITEM_H
#define USERITEM_H

#include "enums.h"
#include <QObject>
#include <QUrl>
#include <QDomElement>
#include <QVariantMap>

class UserItem : public QObject
{
    Q_OBJECT

    Q_PROPERTY(QString id
               READ id
               NOTIFY idChanged)
    Q_PROPERTY(QString username
               READ username
               NOTIFY usernameChanged)
    Q_PROPERTY(QString channelName
               READ channelName
               NOTIFY channelNameChanged)
    Q_PROPERTY(QString description
               READ description
               NOTIFY descriptionChanged)
    Q_PROPERTY(QUrl avatarUrl
               READ avatarUrl
               NOTIFY avatarUrlChanged)
    Q_PROPERTY(QString location
               READ location
               NOTIFY locationChanged)
    Q_PROPERTY(int videoCount
               READ videoCount
               NOTIFY videoCountChanged)
    Q_PROPERTY(int viewCount
               READ viewCount
               NOTIFY viewCountChanged)
    Q_PROPERTY(int subscriberCount
               READ subscriberCount
               NOTIFY subscriberCountChanged)
    Q_PROPERTY(bool subscription
               READ subscription
               NOTIFY subscriptionChanged)
    Q_PROPERTY(bool subscribed
               READ subscribed
               NOTIFY subscribedChanged)
    Q_PROPERTY(QString subscriptionId
               READ subscriptionId
               NOTIFY subscriptionIdChanged)
    Q_PROPERTY(bool accountLinked
               READ accountLinked
               NOTIFY accountLinkedChanged)
    Q_PROPERTY(Services::VideoService service
               READ service
               NOTIFY serviceChanged)

public:
    explicit UserItem(QObject *parent = 0);
    explicit UserItem(UserItem *user, QObject *parent = 0);
    ~UserItem() {}
    Q_INVOKABLE void loadUser(UserItem *user);
    void loadDailymotionUser(const QVariantMap &user, bool subscribed = false);
    void loadYouTubeUser(const QDomNode &user, bool subscription = false, bool subscribed = false);
    void loadVimeoContact(const QDomElement &contact, bool subscribed = false);
    void loadVimeoProfile(const QDomElement &profile);
    inline QString id() const { return m_id; }
    inline void setId(const QString &id) { m_id = id; emit idChanged(id); }
    inline QString username() const { return m_username; }
    inline void setUsername(const QString &user) { m_username = user; emit usernameChanged(user); }
    inline QString channelName() const { return m_channelName; }
    inline void setChannelName(const QString &name) { m_channelName = name; emit channelNameChanged(name); }
    inline QString description() const { return m_description; }
    inline void setDescription(const QString &description) { m_description = description; emit descriptionChanged(description); }
    inline QUrl avatarUrl() const { return m_avatarUrl; }
    inline void setAvatarUrl(const QUrl &url) { m_avatarUrl = url; emit avatarUrlChanged(url); }
    inline QString location() const { return m_location; }
    inline void setLocation(const QString &location) { m_location = location; emit locationChanged(location); }
    inline int videoCount() const { return m_videoCount; }
    inline void setVideoCount(int count) { m_videoCount = count; emit videoCountChanged(count); }
    inline int viewCount() const { return m_viewCount; }
    inline void setViewCount(int count) { m_viewCount = count; emit viewCountChanged(count); }
    inline int subscriberCount() const { return m_subscriberCount; }
    inline void setSubscriberCount(int count) { m_subscriberCount = count; emit subscriberCountChanged(count); }
    inline QUrl websiteUrl() const { return m_websiteUrl; }
    inline void setWebsiteUrl(const QUrl &url) { m_websiteUrl = url; emit websiteUrlChanged(url); }
    inline bool subscription() const { return m_subscription; }
    inline void setSubscription(bool subscription) { m_subscription = subscription; emit subscriptionChanged(subscription); }
    inline bool subscribed() const { return m_subscribed; }
    inline void setSubscribed(bool subscribed) { m_subscribed = subscribed; emit subscribedChanged(subscribed); }
    inline QString subscriptionId() const { return m_subscriptionId; }
    inline void setSubscriptionId(const QString &id) { m_subscriptionId = id; emit subscriptionIdChanged(id); }
    inline bool accountLinked() const { return m_accountLinked; }
    inline Services::VideoService service() const { return m_service; }
    inline void setService(Services::VideoService service) { m_service = service; emit serviceChanged(service); }
    inline bool operator ==(UserItem *other) { return (other->id() == this->id()) || (other->username() == this->username()); }

public slots:
    inline void setAccountLinked(bool linked) { m_accountLinked = linked; emit accountLinkedChanged(linked); }
    void onSubscriptionChanged(const QString &userId, bool subscribed, const QString &subscriptionId = QString());

signals:
    void idChanged(const QString &id);
    void usernameChanged(const QString &username);
    void channelNameChanged(const QString &channelName);
    void descriptionChanged(const QString &description);
    void avatarUrlChanged(const QUrl &url);
    void locationChanged(const QString &location);
    void videoCountChanged(int count);
    void viewCountChanged(int count);
    void subscriberCountChanged(int count);
    void websiteUrlChanged(const QUrl &url);
    void subscriptionChanged(bool subscription);
    void subscribedChanged(bool subscribed);
    void subscriptionIdChanged(const QString &id);
    void accountLinkedChanged(bool linked);
    void serviceChanged(Services::VideoService service);

private:
    QString m_id;
    QString m_username;
    QString m_channelName;
    QString m_description;
    QUrl m_avatarUrl;
    QString m_location;
    int m_videoCount;
    int m_viewCount;
    int m_subscriberCount;
    QUrl m_websiteUrl;
    bool m_subscription;
    bool m_subscribed;
    QString m_subscriptionId;
    bool m_accountLinked;
    Services::VideoService m_service;
};

#endif // USERITEM_H
