#ifndef VIMEOVIDEOSELECTIONWINDOW_H
#define VIMEOVIDEOSELECTIONWINDOW_H

#include "../base/enums.h"
#include <QWidget>
#include <QVariantMap>

class VimeoVideoListModel;
class ListView;
class QMaemo5EditBar;
class QPushButton;
class QVBoxLayout;
class QModelIndex;

class VimeoVideoSelectionWindow : public QWidget
{
    Q_OBJECT

public:
    explicit VimeoVideoSelectionWindow(VimeoVideoListModel *model, const QString &text, const char* slot, QWidget *parent);
    ~VimeoVideoSelectionWindow();
    void positionAtIndex(const QModelIndex &index);

private slots:
    void onItemClicked(const QModelIndex &index);
    void onButtonClicked();
    void deleteVideosFromUploads();
    void addVideosToLikes();
    void deleteVideosFromLikes();
    void showAlbumDialog();
    void addVideosToAlbum(const QString &id);
    void addVideosToNewAlbum(const QVariantMap &album);
    void deleteVideosFromAlbum();
    void addVideosToWatchLaterAlbum();
    void deleteVideosFromWatchLaterAlbum();
    void addVideoDownloads();
    void addAudioDownloads();
    void queueVideos();

signals:
    void accepted();

private:
    VimeoVideoListModel *m_model;
    ListView *m_listView;
    QMaemo5EditBar *m_editBar;
    QPushButton *m_acceptButton;
    QVBoxLayout *m_vbox;
};

#endif // VIMEOVIDEOSELECTIONWINDOW_H
