#include "dailymotionuserplaylistlisttab.h"
#include "dailymotionplaylistdelegate.h"
#include "dailymotionnewplaylistdialog.h"
#include "dailymotionplaylistvideoswindow.h"
#include "listview.h"
#include "../base/dailymotionuserplaylistlistmodel.h"
#include "../base/dailymotion.h"
#include "../base/notifications.h"
#include "../base/windowstack.h"
#include <QLabel>
#include <QMenu>
#include <QAction>
#include <QGridLayout>

DailymotionUserPlaylistListTab::DailymotionUserPlaylistListTab(QWidget *parent) :
    AbstractTab(parent),
    m_listView(new ListView(this)),
    m_model(new DailymotionUserPlaylistListModel(this)),
    m_contextMenu(new QMenu(this)),
    m_deleteAction(m_contextMenu->addAction(tr("Delete"), this, SLOT(deletePlaylist()))),
    m_newPlaylistAction(new QAction(tr("New playlist"), this)),
    m_noResultsLabel(new QLabel(QString("<p style='color:#4d4d4d;font-size:40px;'><center><b>%1</b></center></p>").arg(tr("No playlists found")), this)),
    m_grid(new QGridLayout(this))
{
    this->addAction(m_newPlaylistAction);

    m_grid->setContentsMargins(0, 0, 0, 0);
    m_grid->addWidget(m_listView, 0, 0);
    m_listView->setItemDelegate(new DailymotionPlaylistDelegate(m_listView));
    m_noResultsLabel->hide();

    if (Dailymotion::instance()->playlistsLoaded()) {
        this->onPlaylistsLoaded();
    }
    else {
        Notifications::toggleBusy(true);
        this->connect(Dailymotion::instance(), SIGNAL(allPlaylistsLoaded()), this, SLOT(onPlaylistsLoaded()));
    }

    this->connect(m_model, SIGNAL(countChanged(int)), this, SLOT(onCountChanged(int)));
    this->connect(m_newPlaylistAction, SIGNAL(triggered()), this, SLOT(showNewPlaylistDialog()));

    this->onOrientationChanged();
}

void DailymotionUserPlaylistListTab::setLandscapeLayout() {
    m_noResultsLabel->setFixedSize(800, 400);
}

void DailymotionUserPlaylistListTab::setPortraitLayout() {
    m_noResultsLabel->setFixedSize(480, 700);
}

void DailymotionUserPlaylistListTab::onPlaylistsLoaded() {
    Notifications::toggleBusy(false);
    m_noResultsLabel->setVisible(m_model->rowCount() == 0);
    m_listView->setModel(m_model);

    this->connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    this->connect(m_listView, SIGNAL(customContextMenuRequested(QPoint)), this, SLOT(showContextMenu(QPoint)));
}

void DailymotionUserPlaylistListTab::onCountChanged(int count) {
    m_noResultsLabel->setVisible(count == 0);
}

void DailymotionUserPlaylistListTab::onItemClicked(const QModelIndex &index) {
    if (index.isValid()) {
        this->showPlaylist(m_model->get(index.row()));
    }
}

void DailymotionUserPlaylistListTab::showPlaylist(QSharedPointer<PlaylistItem> playlist) {
    DailymotionPlaylistVideosWindow *window = new DailymotionPlaylistVideosWindow(playlist, WindowStack::instance()->currentWindow());
    window->show();
}

void DailymotionUserPlaylistListTab::showContextMenu(const QPoint &pos) {
    m_contextMenu->popup(pos, m_deleteAction);
}

void DailymotionUserPlaylistListTab::deletePlaylist() {
    Dailymotion::instance()->deletePlaylist(m_listView->currentIndex().data(DailymotionUserPlaylistListModel::PlaylistIdRole).toString());
}

void DailymotionUserPlaylistListTab::showNewPlaylistDialog() {
    DailymotionNewPlaylistDialog *dialog = new DailymotionNewPlaylistDialog(this);
    dialog->open();

    this->connect(dialog, SIGNAL(playlistCreated(QVariantMap)), Dailymotion::instance(), SLOT(createPlaylist(QVariantMap)));
}
