#include "file.h"

File::File(QObject *parent) :
    QFile(parent),
    m_mutex(new QMutex(QMutex::Recursive))
{
}

File::~File() {
    delete m_mutex;
    m_mutex = 0;
}

qint64 File::write(const QByteArray &data) {
    qint64 bytes = 0;
    m_mutex->lock();
    bytes = QFile::write(data);
    m_mutex->unlock();

    return bytes;
}

void File::close() {
    m_mutex->lock();
    QFile::close();
    emit closed();
    m_mutex->unlock();
}
