#ifndef YOUTUBEPLAYLISTDIALOG_H
#define YOUTUBEPLAYLISTDIALOG_H

#include "abstractdialog.h"
#include <QVariantMap>

class Session;
class YouTubeUserPlaylistListModel;
class ListView;
class QDialogButtonBox;
class QPushButton;
class QLabel;
class QGridLayout;
class QModelIndex;

class YouTubePlaylistDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit YouTubePlaylistDialog(Session *session, QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void showNewPlaylistDialog();
    void onItemClicked(const QModelIndex &index);
    void onPlaylistsLoaded();
    
signals:
    void playlistChosen(const QString &id);
    void addToNewPlaylist(const QVariantMap &playlist);

private:
    Session *m_session;
    YouTubeUserPlaylistListModel *m_model;
    ListView *m_listView;
    QDialogButtonBox *m_buttonBox;
    QPushButton *m_newButton;
    QLabel *m_noResultsLabel;
    QGridLayout *m_grid;
};

#endif // YOUTUBEPLAYLISTDIALOG_H
