#include "youtubeplaylistdialog.h"
#include "youtubeplaylistdelegate.h"
#include "youtubenewplaylistdialog.h"
#include "../base/youtubeuserplaylistlistmodel.h"
#include "listview.h"
#include "../base/session.h"
#include <QDialogButtonBox>
#include <QPushButton>
#include <QLabel>
#include <QGridLayout>

YouTubePlaylistDialog::YouTubePlaylistDialog(Session *session, QWidget *parent) :
    AbstractDialog(parent),
    m_session(session),
    m_model(new YouTubeUserPlaylistListModel(m_session, this)),
    m_listView(new ListView(this)),
    m_buttonBox(new QDialogButtonBox(Qt::Vertical, this)),
    m_newButton(m_buttonBox->addButton(tr("New playlist"), QDialogButtonBox::ActionRole)),
    m_noResultsLabel(new QLabel(tr("No playlists found"), this)),
    m_grid(new QGridLayout(this))
{
    this->setWindowTitle(tr("Add to playlist"));
    this->toggleBusy(true);

    m_listView->setItemDelegate(new YouTubePlaylistDelegate(m_listView));

    QFont font;
    font.setPixelSize(40);
    font.setBold(true);
    m_noResultsLabel->setFont(font);
    m_noResultsLabel->setAlignment(Qt::AlignCenter);
    m_noResultsLabel->hide();

    this->connect(m_newButton, SIGNAL(clicked()), this, SLOT(showNewPlaylistDialog()));
    this->connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));

    if (m_session->youtube()->playlistsLoaded()) {
        this->onPlaylistsLoaded();
    }
    else {
        this->connect(m_session->youtube(), SIGNAL(allPlaylistsLoaded()), this, SLOT(onPlaylistsLoaded()));
    }

    this->onOrientationChanged();
}

void YouTubePlaylistDialog::setLandscapeLayout() {
    this->setFixedHeight(340);
    m_noResultsLabel->setFixedSize(800, 340);
    m_buttonBox->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_listView, 0, 0);
        m_grid->addWidget(m_buttonBox, 0, 1, Qt::AlignBottom);
    }
    else {
        m_grid->removeWidget(m_buttonBox);
        m_grid->addWidget(m_buttonBox, 0, 1, Qt::AlignBottom);
    }
}

void YouTubePlaylistDialog::setPortraitLayout() {
    this->setFixedHeight(600);
    m_noResultsLabel->setFixedSize(480, 600);
    m_buttonBox->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_listView, 0, 0);
        m_grid->addWidget(m_buttonBox, 1, 0, Qt::AlignBottom);
    }
    else {
        m_grid->removeWidget(m_buttonBox);
        m_grid->addWidget(m_buttonBox, 1, 0, Qt::AlignBottom);
    }
}

void YouTubePlaylistDialog::onPlaylistsLoaded() {
    this->toggleBusy(false);
    m_noResultsLabel->setVisible(m_model->rowCount() == 0);
    m_listView->setModel(m_model);
}

void YouTubePlaylistDialog::onItemClicked(const QModelIndex &index) {
    if (index.isValid()) {
        emit playlistChosen(index.data(YouTubeUserPlaylistListModel::PlaylistIdRole).toString());
        this->accept();
    }
}

void YouTubePlaylistDialog::showNewPlaylistDialog() {
    YouTubeNewPlaylistDialog *dialog = new YouTubeNewPlaylistDialog(this);
    dialog->open();
    this->connect(dialog, SIGNAL(playlistCreated(QVariantMap)), this, SIGNAL(addToNewPlaylist(QVariantMap)));
    this->connect(dialog, SIGNAL(accepted()), this, SLOT(accept()));
}
