#ifndef VIMEOUSERALBUMLISTTAB_H
#define VIMEOUSERALBUMLISTTAB_H

#include "abstracttab.h"
#include "../base/playlistitem.h"

class Session;
class ListView;
class VimeoUserAlbumListModel;
class QLabel;
class QMenu;
class QAction;
class QGridLayout;
class QModelIndex;

class VimeoUserAlbumListTab : public AbstractTab
{
    Q_OBJECT
public:
    explicit VimeoUserAlbumListTab(Session *session, QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onAlbumsLoaded();
    void onCountChanged(int count);
    void onItemClicked(const QModelIndex &index);
    void showAlbum(QSharedPointer<PlaylistItem> album);
    void showContextMenu(const QPoint &pos);
    void deleteAlbum();
    void showNewAlbumDialog();

private:
    Session *m_session;
    ListView *m_listView;
    VimeoUserAlbumListModel *m_model;
    QMenu *m_contextMenu;
    QAction *m_deleteAction;
    QAction *m_newAlbumAction;
    QLabel *m_noResultsLabel;
    QGridLayout *m_grid;
};

#endif // VIMEOUSERALBUMLISTTAB_H
