#ifndef VIMEOPROFILETAB_H
#define VIMEOPROFILETAB_H

#include "abstracttab.h"
#include "../base/useritem.h"

class Session;
class SeparatorLabel;
class AvatarLabel;
class QLabel;
class QPushButton;
class QScrollArea;
class QAction;
class QGridLayout;

class VimeoProfileTab : public AbstractTab
{
    Q_OBJECT

public:
    explicit VimeoProfileTab(Session *session, const QString &userId, QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void setUser(QSharedPointer<UserItem> user);
    void setAvatar();
    void onProfileError();
    void toggleSubscription();
    void onSubscribedChanged(bool subscribed);
    void showUserWebsite();
    void showWatchLaterAlbum();

private:
    Session *m_session;
    QSharedPointer<UserItem> m_user;
    AvatarLabel *m_avatar;
    QLabel *m_channelLabel;
    QLabel *m_videosLabel;
    QLabel *m_locationLabel;
    QLabel *m_websiteLabel;
    QLabel *m_descriptionLabel;
    QLabel *m_noProfileLabel;
    QPushButton *m_subscriptionButton;
    QAction *m_watchLaterAction;
    QScrollArea *m_scrollArea;
    QGridLayout *m_grid;
};

#endif // VIMEOPROFILETAB_H
