#include "vimeochannelwindow.h"
#include "vimeoprofiletab.h"
#include "vimeovideolisttab.h"
#include "vimeoalbumlisttab.h"
#include "vimeogrouplisttab.h"
#include "vimeouserlisttab.h"
#include "../base/feedurls.h"
#include <QStackedWidget>
#include <QActionGroup>
#include <QMenu>
#include <QMenuBar>

VimeoChannelWindow::VimeoChannelWindow(Session *session, const QString &userId, QWidget *parent) :
    StackedWindow(session, parent),
    m_userId(userId),
    m_menu(this->menuBar()->addMenu("")),
    m_actionGroup(new QActionGroup(this)),
    m_profileAction(new QAction("Pro", this)),
    m_uploadsAction(new QAction("Upl", this)),
    m_likesAction(new QAction("Like", this)),
    m_albumsAction(new QAction("Alb", this)),
    m_groupsAction(new QAction("Gro", this)),
    m_subscriptionsAction(new QAction("Subs", this)),
    m_tabWidget(new QStackedWidget(this)),
    m_profileTab(new VimeoProfileTab(m_session, m_userId, m_tabWidget)),
    m_uploadsTab(0),
    m_likesTab(0),
    m_albumsTab(0),
    m_groupsTab(0),
    m_subscriptionsTab(0)
{
    this->setCentralWidget(m_tabWidget);

    m_profileAction->setCheckable(true);
    m_profileAction->setActionGroup(m_actionGroup);

    m_uploadsAction->setCheckable(true);
    m_uploadsAction->setActionGroup(m_actionGroup);

    m_likesAction->setCheckable(true);
    m_likesAction->setActionGroup(m_actionGroup);

    m_albumsAction->setCheckable(true);
    m_albumsAction->setActionGroup(m_actionGroup);

    m_groupsAction->setCheckable(true);
    m_groupsAction->setActionGroup(m_actionGroup);

    m_subscriptionsAction->setCheckable(true);
    m_subscriptionsAction->setActionGroup(m_actionGroup);

    m_menu->addAction(m_profileAction);
    m_menu->addAction(m_uploadsAction);
    m_menu->addAction(m_likesAction);
    m_menu->addAction(m_albumsAction);
    m_menu->addAction(m_groupsAction);
    m_menu->addAction(m_subscriptionsAction);

    m_profileAction->setChecked(true);

    m_tabWidget->setFrameStyle(QFrame::NoFrame);
    m_tabWidget->addWidget(m_profileTab);

    this->connect(m_profileAction, SIGNAL(triggered()), this, SLOT(showProfile()));
    this->connect(m_uploadsAction, SIGNAL(triggered()), this, SLOT(showUploads()));
    this->connect(m_likesAction, SIGNAL(triggered()), this, SLOT(showLikes()));
    this->connect(m_albumsAction, SIGNAL(triggered()), this, SLOT(showAlbums()));
    this->connect(m_groupsAction, SIGNAL(triggered()), this, SLOT(showGroups()));
    this->connect(m_subscriptionsAction, SIGNAL(triggered()), this, SLOT(showSubscriptions()));

    this->showProfile();
    this->onOrientationChanged();
}

void VimeoChannelWindow::clearMenuActions() {
    QList<QAction*> actions = this->menuBar()->actions();

    for (int i = 1; i < actions.size(); i++) {
        this->menuBar()->removeAction(actions.at(i));
    }
}

void VimeoChannelWindow::showProfile() {
    m_tabWidget->setCurrentWidget(m_profileTab);
    this->setWindowTitle(tr("Profile"));
    this->clearMenuActions();
}

void VimeoChannelWindow::showUploads() {
    if (!m_uploadsTab) {
        m_uploadsTab = new VimeoVideoListTab(m_session, this);
        m_uploadsTab->setVideoFeed(QString("%1?method=vimeo.videos.getUploaded&user_id=%2&full_response=true&per_page=30&sort=newest").arg(QString(VIMEO_BASE_URL)).arg(m_userId));
        m_tabWidget->addWidget(m_uploadsTab);
    }

    m_tabWidget->setCurrentWidget(m_uploadsTab);
    this->setWindowTitle(tr("Uploads"));
    this->clearMenuActions();
    this->menuBar()->addActions(m_uploadsTab->actions());
}

void VimeoChannelWindow::showLikes() {
    if (!m_likesTab) {
        m_likesTab = new VimeoVideoListTab(m_session, this);
        m_likesTab->setVideoFeed(QString("%1?method=vimeo.videos.getLikes&user_id=%2&full_response=true&per_page=30&sort=newest").arg(QString(VIMEO_BASE_URL)).arg(m_userId));
        m_tabWidget->addWidget(m_likesTab);
    }

    m_tabWidget->setCurrentWidget(m_likesTab);
    this->setWindowTitle(tr("Likes"));
    this->clearMenuActions();
    this->menuBar()->addActions(m_likesTab->actions());
}

void VimeoChannelWindow::showAlbums() {
    if (!m_albumsTab) {
        m_albumsTab = new VimeoAlbumListTab(m_session, this);
        m_albumsTab->setAlbumFeed(QString("%1?method=vimeo.albums.getAll&user_id=%2&per_page=30&sort=newest").arg(QString(VIMEO_BASE_URL)).arg(m_userId));
        m_tabWidget->addWidget(m_albumsTab);
    }

    m_tabWidget->setCurrentWidget(m_albumsTab);
    this->setWindowTitle(tr("Albums"));
    this->clearMenuActions();
}

void VimeoChannelWindow::showGroups() {
    if (!m_groupsTab) {
        m_groupsTab = new VimeoGroupListTab(m_session, this);
        m_groupsTab->setGroupFeed(QString("%1?method=vimeo.groups.getAll&user_id=%2&per_page=30&sort=newest").arg(QString(VIMEO_BASE_URL)).arg(m_userId));
        m_tabWidget->addWidget(m_groupsTab);
    }

    m_tabWidget->setCurrentWidget(m_groupsTab);
    this->setWindowTitle(tr("Groups"));
    this->clearMenuActions();
}

void VimeoChannelWindow::showSubscriptions() {
    if (!m_subscriptionsTab) {
        m_subscriptionsTab = new VimeoUserListTab(m_session, m_userId, this);
        m_subscriptionsTab->setFeed(QString("%1?method=vimeo.contacts.getAll&user_id=%2&per_page=30&sort=alphabetical").arg(QString(VIMEO_BASE_URL)).arg(m_userId));
        m_tabWidget->addWidget(m_subscriptionsTab);
    }

    m_tabWidget->setCurrentWidget(m_subscriptionsTab);
    this->setWindowTitle(tr("Subscriptions"));
    this->clearMenuActions();
    this->menuBar()->addActions(m_subscriptionsTab->actions());
}
