#include "vimeocategoriesdialog.h"
#include "textlistdelegate.h"
#include "../base/vimeocategorymodel.h"
#include "listview.h"
#include "separatorlabel.h"
#include <QVBoxLayout>

VimeoCategoriesDialog::VimeoCategoriesDialog(QWidget *parent) :
    AbstractDialog(parent),
    m_model(new VimeoCategoryModel(this)),
    m_view(new ListView(this))
{
    this->setWindowTitle(tr("Vimeo categories"));
    m_view->setModel(m_model);
    m_view->setModel(m_model);
    m_view->setItemDelegate(new TextListDelegate(Qt::DisplayRole, Qt::AlignVCenter, m_view));
    m_view->setMinimumHeight(m_view->sizeHintForRow(0) * 5);

    QVBoxLayout *vbox = new QVBoxLayout(this);
    vbox->addWidget(m_view);

    this->connect(m_view, SIGNAL(clicked(QModelIndex)), this, SLOT(onCategoryChosen(QModelIndex)));
}

void VimeoCategoriesDialog::onCategoryChosen(const QModelIndex &index) {
    emit categoryChosen(Services::Vimeo, m_model->name(index.row()), m_model->value(index.row()).toString());
    this->accept();
}
