#include "vimeoalbumlisttab.h"
#include "vimeoalbumlistdelegate.h"
#include "vimeoalbumvideoswindow.h"
#include "listview.h"
#include "../base/vimeoalbumlistmodel.h"
#include "../base/session.h"
#include <QLabel>
#include <QGridLayout>

VimeoAlbumListTab::VimeoAlbumListTab(Session *session, QWidget *parent) :
    AbstractTab(parent),
    m_session(session),
    m_listView(new ListView(this)),
    m_model(new VimeoAlbumListModel(m_session, this)),
    m_noResultsLabel(new QLabel(QString("<p style='color:#4d4d4d;font-size:40px;'><center><b>%1</b></center></p>").arg(tr("No albums found")), this)),
    m_grid(new QGridLayout(this))
{
    m_grid->setContentsMargins(0, 0, 0, 0);
    m_grid->addWidget(m_listView, 0, 0);
    m_listView->setModel(m_model);
    m_listView->setItemDelegate(new VimeoAlbumListDelegate(m_listView));
    m_noResultsLabel->hide();

    this->connect(m_model, SIGNAL(loadingChanged(bool)), this, SLOT(onLoadingChanged(bool)));
    this->connect(m_model, SIGNAL(countChanged(int)), this, SLOT(onCountChanged(int)));
    this->connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    this->connect(m_listView, SIGNAL(atEnd()), m_model, SLOT(getMoreAlbums()));

    this->onOrientationChanged();
}

void VimeoAlbumListTab::setAlbumFeed(const QString &feed) {
    m_model->getAlbums(feed);
}

void VimeoAlbumListTab::setLandscapeLayout() {
    m_noResultsLabel->setFixedSize(800, 400);
}

void VimeoAlbumListTab::setPortraitLayout() {
    m_noResultsLabel->setFixedSize(480, 700);
}

void VimeoAlbumListTab::onLoadingChanged(bool loading) {
    m_session->toggleBusy(loading);
    m_noResultsLabel->setVisible((!loading) && (m_model->rowCount() == 0));
}

void VimeoAlbumListTab::onCountChanged(int count) {
    m_noResultsLabel->setVisible((count == 0) && (!m_model->loading()));
}

void VimeoAlbumListTab::onItemClicked(const QModelIndex &index) {
    if (index.isValid()) {
        this->showAlbum(m_model->get(index.row()));
    }
}

void VimeoAlbumListTab::showAlbum(QSharedPointer<PlaylistItem> album) {
    VimeoAlbumVideosWindow *window = new VimeoAlbumVideosWindow(m_session, album, m_session->currentWindow());
    window->show();
}
