#ifndef TWITTERAUTHDIALOG_H
#define TWITTERAUTHDIALOG_H

#include "abstractdialog.h"

class Session;
class WebView;
class QProgressBar;
class QGridLayout;
class QUrl;

class TwitterAuthDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit TwitterAuthDialog(Session *session, QWidget *parent = 0);

private:
    inline void setLandscapeLayout() { this->setFixedHeight(340); }
    inline void setPortraitLayout() { this->setFixedHeight(600); }

private slots:
    void setAuthUrl(const QUrl &url);
    void checkUrlForToken(const QUrl &url);
        
private:
    Session *m_session;
    WebView *m_webView;
    QProgressBar *m_progressBar;
    QGridLayout *m_grid;
};

#endif // TWITTERAUTHDIALOG_H
