#include "transfermovedialog.h"
#include "transfermovedelegate.h"
#include "../base/transferlistmodel.h"
#include <QListView>
#include <QGridLayout>

TransferMoveDialog::TransferMoveDialog(TransferListModel *model, QWidget *parent) :
    AbstractDialog(parent),
    m_model(model),
    m_listView(new QListView(this))
{
    this->setWindowTitle(tr("Move"));
    this->setAttribute(Qt::WA_DeleteOnClose, true);
    this->setFixedHeight(340);

    QGridLayout *grid = new QGridLayout(this);
    grid->setContentsMargins(0, 0, 0, 0);
    grid->addWidget(m_listView, 0, 0);

    m_listView->setModel(m_model);
    m_listView->setItemDelegate(new TransferMoveDelegate(m_listView));

    this->connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
}

void TransferMoveDialog::setValue(int value) {
    m_listView->setCurrentIndex(m_model->index(value, 0));
}

int TransferMoveDialog::currentValue() const {
    return m_listView->currentIndex().row();
}

void TransferMoveDialog::onItemClicked(const QModelIndex &index) {
    emit valueChanged(index.row());
    this->accept();
}
