#include "playbackvideoselectionwindow.h"
#include "videoselectiondelegate.h"
#include "../base/session.h"
#include "listview.h"
#include <QMaemo5EditBar>
#include <QPushButton>
#include <QVBoxLayout>

PlaybackVideoSelectionWindow::PlaybackVideoSelectionWindow(Session *session, const QString &text, const char* slot, QWidget *parent) :
    QWidget(parent),
    m_session(session),
    m_listView(new ListView(this)),
    m_editBar(new QMaemo5EditBar(tr("Select videos"), this)),
    m_acceptButton(new QPushButton(text, this)),
    m_vbox(new QVBoxLayout(this))
{
    this->setWindowFlags(Qt::Window);
    this->setWindowState(Qt::WindowFullScreen);
    this->setAttribute(Qt::WA_Maemo5StackedWindow, true);
    this->setAttribute(Qt::WA_DeleteOnClose, true);

    m_listView->setModel(m_session->playbackQueue());
    m_listView->setItemDelegate(new VideoSelectionDelegate(m_listView));
    m_editBar->addButton(m_acceptButton);

    m_vbox->setContentsMargins(0, 0, 0, 0);
    m_vbox->addWidget(m_editBar);
    m_vbox->addWidget(m_listView);

    this->connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    this->connect(m_acceptButton, SIGNAL(clicked()), this, SLOT(onButtonClicked()));
    this->connect(this, SIGNAL(accepted()), this, slot);
}

PlaybackVideoSelectionWindow::~PlaybackVideoSelectionWindow() {
    m_session->playbackQueue()->selectNone();
}

void PlaybackVideoSelectionWindow::positionAtIndex(const QModelIndex &index) {
    m_listView->scrollTo(index, QListView::PositionAtTop);
}

void PlaybackVideoSelectionWindow::onItemClicked(const QModelIndex &index) {
    m_session->playbackQueue()->toggleSelected(index.row());
}

void PlaybackVideoSelectionWindow::onButtonClicked() {
    if (m_session->playbackQueue()->itemsSelected()) {
        emit accepted();
    }
}

void PlaybackVideoSelectionWindow::addVideoDownloads() {
    m_session->playbackQueue()->downloadSelectedVideos();
    this->close();
}

void PlaybackVideoSelectionWindow::addAudioDownloads() {
    m_session->playbackQueue()->downloadSelectedVideos(true);
    this->close();
}

void PlaybackVideoSelectionWindow::removeVideos() {
    m_session->playbackQueue()->removeSelectedVideos();
    this->close();
}
