#ifndef GROUPITEM_H
#define GROUPITEM_H

#include <QObject>
#include <QUrl>
#include <QVariantMap>
#include <QDomElement>

class GroupItem : public QObject
{
    Q_OBJECT

    Q_PROPERTY(QString id
               READ id
               CONSTANT)
    Q_PROPERTY(QString title
               READ title
               CONSTANT)
    Q_PROPERTY(QString artist
               READ artist
               CONSTANT)
    Q_PROPERTY(QString artistId
               READ artistId
               CONSTANT)
    Q_PROPERTY(QUrl artistAvatarUrl
               READ artistAvatarUrl
               CONSTANT)
    Q_PROPERTY(QString description
               READ description
               CONSTANT)
    Q_PROPERTY(QString date
               READ date
               CONSTANT)
    Q_PROPERTY(QUrl thumbnailUrl
               READ thumbnailUrl
               CONSTANT)
    Q_PROPERTY(int videoCount
               READ videoCount
               NOTIFY videoCountChanged)
    Q_PROPERTY(bool member
               READ member
               WRITE setMember
               NOTIFY memberChanged)

public:
    explicit GroupItem(QObject *parent = 0);
    explicit GroupItem(GroupItem *group, QObject *parent = 0);
    ~GroupItem() {}
    void loadDailymotionGroup(const QVariantMap &group, bool member = false);
    void loadVimeoGroup(const QDomElement &group);
    inline QString id() const { return m_id; }
    inline void setId(const QString &id) { m_id = id; }
    inline QString title() const { return m_title; }
    inline void setTitle(const QString &title) { m_title = title; }
    inline QString artist() const { return m_artist; }
    inline void setArtist(const QString &artist) { m_artist = artist; }
    inline QString artistId() const { return m_artistId; }
    inline void setArtistId(const QString &id) { m_artistId = id; }
    inline QUrl artistAvatarUrl() const { return m_artistAvatarUrl; }
    inline void setArtistAvatarUrl(const QUrl &url) { m_artistAvatarUrl = url; }
    inline QString description() const { return m_description; }
    inline void setDescription(const QString &description) { m_description = description; }
    inline QString date() const { return m_date; }
    inline void setDate(const QString &date) { m_date = date; }
    inline QUrl thumbnailUrl() const { return m_thumbnailUrl; }
    inline void setThumbnailUrl(const QUrl &url) { m_thumbnailUrl = url; }
    inline int videoCount() const { return m_videoCount; }
    inline void setVideoCount(int count) { m_videoCount = count; emit videoCountChanged(count); }
    inline bool member() const { return m_member; }
    inline void setMember(bool member) { m_member = member; emit memberChanged(member); }

public slots:
    void onMembershipChanged(const QString &groupId, bool member);

signals:
    void memberChanged(bool member);
    void videoCountChanged(int count);

private:
    QString m_id;
    QString m_title;
    QString m_artist;
    QString m_artistId;
    QUrl m_artistAvatarUrl;
    QString m_description;
    QString m_date;
    QUrl m_thumbnailUrl;
    int m_videoCount;
    bool m_member;
};

#endif // GROUPITEM_H
