#ifndef COOKIEJAR_H
#define COOKIEJAR_H

#include <QNetworkCookieJar>

class CookieJar : public QNetworkCookieJar
{
    Q_OBJECT

    Q_PROPERTY(bool youtubeCookiesSet
               READ youtubeCookiesSet
               CONSTANT)
    Q_PROPERTY(bool dailymotionCookiesSet
               READ dailymotionCookiesSet
               CONSTANT)
    Q_PROPERTY(bool vimeoCookiesSet
               READ vimeoCookiesSet
               CONSTANT)

public:
    enum Mode {
        PlaybackMode = 0,
        DownloadMode
    };

public:
    explicit CookieJar(CookieJar::Mode mode = CookieJar::DownloadMode, QObject *parent = 0);
    ~CookieJar() {}
    bool youtubeCookiesSet() const;
    bool dailymotionCookiesSet() const;
    bool vimeoCookiesSet() const;
    QList<QNetworkCookie> cookiesForUrl(const QUrl &url) const;

public slots:
    void setYouTubeCookies(const QByteArray &rawCookie);
    void setYouTubeCookies();
    void setDailymotionCookies(const QByteArray &rawCookie);
    void setDailymotionCookies();
    void setVimeoCookies(const QByteArray &rawCookie);
    void setVimeoCookies();
    void storeYouTubeCookies();
    void storeDailymotionCookies();
    void storeVimeoCookies();
    void clearYouTubeCookies();
    void clearYouTubeCookiesFromDB(bool displayAlert = false);
    void clearDailymotionCookies();
    void clearDailymotionCookiesFromDB(bool displayAlert = false);
    void clearVimeoCookies();
    void clearVimeoCookiesFromDB(bool displayAlert = false);
    void clearTwitterCookies();

signals:
    void alert(const QString &message);
    void gotYouTubeCookies(const QByteArray &cookieString);
    void gotDailymotionCookies(const QByteArray &cookieString);
    void gotVimeoCookies(const QByteArray &cookieString);

private:
    CookieJar::Mode m_mode;
    QList<QNetworkCookie> m_dailymotionCookies;
    QList<QNetworkCookie> m_youtubeCookies;
    QList<QNetworkCookie> m_vimeoCookies;
};

#endif // COOKIEJAR_H
