#ifndef ABSTRACTUSERLISTMODEL_H
#define ABSTRACTUSERLISTMODEL_H

#include "useritem.h"
#include <QAbstractListModel>
#include <QSharedPointer>

class ThumbnailCache;

class AbstractUserListModel : public QAbstractListModel
{
    Q_OBJECT

public:
    enum Roles {
        IdRole = Qt::UserRole + 1,
        SubscriptionIdRole,
        UsernameRole,
        ChannelNameRole,
        AvatarRole,
        AvatarUrlRole,
        VideoCountRole,
        DescriptionRole,
        ViewCountRole,
        SubscriberCountRole,
        SubscriptionRole
    };

public:
    explicit AbstractUserListModel(ThumbnailCache *cache = 0, QObject *parent = 0);
    ~AbstractUserListModel();
    inline ThumbnailCache* thumbnailCache() const { return m_cache; }
    void setThumbnailCache(ThumbnailCache *cache);
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role) const;
    Q_INVOKABLE QVariant data(int row, const QByteArray &role) const;
    QSharedPointer<UserItem> get(int row) const;
    Q_INVOKABLE UserItem* getFromQML(int row) const;
    void insertUser(int row, QSharedPointer<UserItem> user);
    void appendUser(QSharedPointer<UserItem> user);
    bool removeUser(const QVariant &value, int role = IdRole);

public slots:
    void clear();
    
protected:
    bool removeRow(int row, const QModelIndex &parent = QModelIndex());

protected slots:
    void onThumbnailReady();

protected:
    ThumbnailCache *m_cache;
    QList< QSharedPointer<UserItem> > m_list;
};

#endif // ABSTRACTUSERLISTMODEL_H
