#ifndef YOUTUBEVIDEOLISTTAB_H
#define YOUTUBEVIDEOLISTTAB_H

#include "abstracttab.h"
#include "../base/videoitem.h"

class Session;
class YouTubeVideoListModel;
class ListView;
class QAction;
class QLabel;
class QGridLayout;
class QModelIndex;
class QMenu;

class YouTubeVideoListTab : public AbstractTab
{
    Q_OBJECT

public:
    explicit YouTubeVideoListTab(Session *session, QWidget *parent = 0);
    void setVideoFeed(const QString &feed);

protected:
    void showEvent(QShowEvent *event);
    
private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void setMenuActions();
    void onLoadingChanged(bool loading);
    void onCountChanged(int count);
    void deleteVideosFromUploads();
    void addVideosToFavourites();
    void deleteVideosFromFavourites();
    void addVideosToPlaylist();
    void addVideosToWatchLaterPlaylist();
    void addVideoDownloads();
    void addAudioDownloads();
    void queueVideos();
    void showContextMenu(const QPoint &pos);
    void deleteVideoFromUploads();
    void addVideoToFavourites();
    void deleteVideoFromFavourites();
    void showPlaylistDialog();
    void addVideoToPlaylist(const QString &id);
    void addVideoToNewPlaylist(const QVariantMap &playlist);
    void addVideoToWatchLaterPlaylist();
    void addVideoDownload();
    void addAudioDownload();
    void queueVideo();
    void onItemClicked(const QModelIndex &index);
    void showVideoInfo(QSharedPointer<VideoItem> video);
    void playVideo(const QModelIndex &index);

private:
    Session *m_session;
    YouTubeVideoListModel *m_model;
    ListView *m_listView;
    QAction *m_deleteFromUploadsAction;
    QAction *m_addToFavouritesAction;
    QAction *m_deleteFromFavouritesAction;
    QAction *m_addToPlaylistAction;
    QAction *m_watchLaterAction;
    QAction *m_addToQueueAction;
    QAction *m_videoDownloadAction;
    QAction *m_audioDownloadAction;
    QMenu *m_contextMenu;
    QAction *m_deleteFromUploadsContextAction;
    QAction *m_addToFavouritesContextAction;
    QAction *m_deleteFromFavouritesContextAction;
    QAction *m_addToPlaylistContextAction;
    QAction *m_watchLaterContextAction;
    QAction *m_addToQueueContextAction;
    QAction *m_videoDownloadContextAction;
    QAction *m_audioDownloadContextAction;
    QLabel *m_noResultsLabel;
    QGridLayout *m_grid;
};

#endif // YOUTUBEVIDEOLISTTAB_H
