#include "youtubeuserlisttab.h"
#include "youtubeuserlistdelegate.h"
#include "youtubevideolistwindow.h"
#include "youtubechannelwindow.h"
#include "../base/youtubeuserlistmodel.h"
#include "listview.h"
#include "../base/session.h"
#include <QLabel>
#include <QGridLayout>
#include <QAction>

YouTubeUserListTab::YouTubeUserListTab(Session *session, const QString &userId, QWidget *parent) :
    AbstractTab(parent),
    m_session(session),
    m_userId(userId),
    m_model(new YouTubeUserListModel(m_session, this)),
    m_listView(new ListView(this)),
    m_videosAction(new QAction(tr("Latest videos"), this)),
    m_noResultsLabel(new QLabel(QString("<p style='color:#4d4d4d;font-size:40px;'><center><b>%1</b></center></p>").arg(tr("No subscriptions found")), this)),
    m_grid(new QGridLayout(this))
{
    this->addAction(m_videosAction);

    m_grid->setContentsMargins(0, 0, 0, 0);
    m_grid->addWidget(m_listView, 0, 0);
    m_listView->setModel(m_model);
    m_listView->setItemDelegate(new YouTubeUserListDelegate(m_listView));
    m_noResultsLabel->hide();

    this->connect(m_model, SIGNAL(loadingChanged(bool)), this, SLOT(onLoadingChanged(bool)));
    this->connect(m_model, SIGNAL(countChanged(int)), this, SLOT(onCountChanged(int)));
    this->connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    this->connect(m_listView, SIGNAL(atEnd()), m_model, SLOT(getMoreUsers()));
    this->connect(m_videosAction, SIGNAL(triggered()), this, SLOT(showSubscriptionVideos()));

    this->onOrientationChanged();
}

void YouTubeUserListTab::setFeed(const QString &feed) {
    m_model->getUsers(feed);
}

void YouTubeUserListTab::setLandscapeLayout() {
    m_noResultsLabel->setFixedSize(800, 400);
}

void YouTubeUserListTab::setPortraitLayout() {
    m_noResultsLabel->setFixedSize(480, 700);
}

void YouTubeUserListTab::onLoadingChanged(bool loading) {
    m_session->toggleBusy(loading);
    m_noResultsLabel->setVisible((!loading) && (m_model->rowCount() == 0));
}

void YouTubeUserListTab::onCountChanged(int count) {
    m_noResultsLabel->setVisible((count == 0) && (!m_model->loading()));
}

void YouTubeUserListTab::onItemClicked(const QModelIndex &index) {
    if (index.isValid()) {
        this->showUserChannel(index.data(AbstractUserListModel::IdRole).toString());
    }
}

void YouTubeUserListTab::showUserChannel(const QString &userId) {
    YouTubeChannelWindow *window = new YouTubeChannelWindow(m_session, userId, m_session->currentWindow());
    window->show();
}

void YouTubeUserListTab::showSubscriptionVideos() {
    YouTubeVideoListWindow *window = new YouTubeVideoListWindow(m_session, m_session->currentWindow());
    window->setVideoFeed(QString("https://gdata.youtube.com/feeds/api/users/%1/newsubscriptionvideos?v=2.1&max-results=30").arg(m_userId));
}
