#ifndef YOUTUBEUPLOADDIALOG_H
#define YOUTUBEUPLOADDIALOG_H

#include "abstractdialog.h"
#include <QVariantMap>

class Session;
class YouTubeUploadCategorySelector;
class QLineEdit;
class QTextEdit;
class QPushButton;
class QCheckBox;
class QDialogButtonBox;
class QScrollArea;
class QGridLayout;
class QMaemo5ValueButton;

class YouTubeUploadDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit YouTubeUploadDialog(Session *session, QWidget *parent = 0);
    
private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void setVideoFile();
    void onTitleTextChanged(const QString &text);
    void uploadVideo();

private:
    Session *m_session;
    QVariantMap m_metadata;
    QMaemo5ValueButton *m_fileSelector;
    QLineEdit *m_titleEdit;
    QTextEdit *m_descriptionEdit;
    QLineEdit *m_tagsEdit;
    YouTubeUploadCategorySelector *m_categorySelector;
    QCheckBox *m_privateCheckbox;
    QDialogButtonBox *m_buttonBox;
    QPushButton *m_doneButton;
    QScrollArea *m_scrollArea;
    QGridLayout *m_grid;
};

#endif // YOUTUBEUPLOADDIALOG_H
