#ifndef YOUTUBECATEGORIESDIALOG_H
#define YOUTUBECATEGORIESDIALOG_H

#include "abstractdialog.h"
#include "../base/enums.h"

class YouTubeCategoryModel;
class ListView;
class QModelIndex;

class YouTubeCategoriesDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit YouTubeCategoriesDialog(QWidget *parent = 0);

private slots:
    void onCategoryChosen(const QModelIndex &index);

signals:
    void categoryChosen(Services::VideoService, const QString &title, const QString &feed);

private:
    YouTubeCategoryModel *m_model;
    ListView *m_view;
};

#endif // YOUTUBECATEGORIESDIALOG_H
