#include "vimeovideoselectionwindow.h"
#include "videoselectiondelegate.h"
#include "vimeoalbumdialog.h"
#include "../base/vimeovideolistmodel.h"
#include "../base/session.h"
#include "listview.h"
#include <QMaemo5EditBar>
#include <QPushButton>
#include <QVBoxLayout>

VimeoVideoSelectionWindow::VimeoVideoSelectionWindow(Session *session, VimeoVideoListModel *model, const QString &text, const char* slot, QWidget *parent) :
    QWidget(parent),
    m_session(session),
    m_model(model),
    m_listView(new ListView(this)),
    m_editBar(new QMaemo5EditBar(tr("Select videos"), this)),
    m_acceptButton(new QPushButton(text, this)),
    m_vbox(new QVBoxLayout(this))
{
    this->setWindowFlags(Qt::Window);
    this->setWindowState(Qt::WindowFullScreen);
    this->setAttribute(Qt::WA_Maemo5StackedWindow, true);
    this->setAttribute(Qt::WA_DeleteOnClose, true);

    m_listView->setModel(m_model);
    m_listView->setItemDelegate(new VideoSelectionDelegate(m_listView));

    m_editBar->addButton(m_acceptButton);
    m_vbox->setContentsMargins(0, 0, 0, 0);
    m_vbox->setSpacing(0);
    m_vbox->addWidget(m_editBar);
    m_vbox->addWidget(m_listView);

    this->connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    this->connect(m_acceptButton, SIGNAL(clicked()), this, SLOT(onButtonClicked()));
    this->connect(this, SIGNAL(accepted()), this, slot);
}

VimeoVideoSelectionWindow::~VimeoVideoSelectionWindow() {
    m_model->selectNone();
}

void VimeoVideoSelectionWindow::positionAtIndex(const QModelIndex &index) {
    m_listView->scrollTo(index, QListView::PositionAtTop);
}

void VimeoVideoSelectionWindow::onItemClicked(const QModelIndex &index) {
    m_model->toggleSelected(index.row());
}

void VimeoVideoSelectionWindow::onButtonClicked() {
    if (m_model->itemsSelected()) {
        emit accepted();
    }
}

void VimeoVideoSelectionWindow::deleteVideosFromUploads() {
    m_model->deleteSelectedVideosFromUploads();
    this->close();
}

void VimeoVideoSelectionWindow::addVideosToLikes() {
    m_model->addSelectedVideosToLikes();
    this->close();
}

void VimeoVideoSelectionWindow::deleteVideosFromLikes() {
    m_model->deleteSelectedVideosFromLikes();
    this->close();
}

void VimeoVideoSelectionWindow::showAlbumDialog() {
    VimeoAlbumDialog *dialog = new VimeoAlbumDialog(m_session, this);
    dialog->open();

    this->connect(dialog, SIGNAL(albumChosen(QString)), this, SLOT(addVideosToAlbum(QString)));
    this->connect(dialog, SIGNAL(addToNewAlbum(QVariantMap)), this, SLOT(addVideosToNewAlbum(QVariantMap)));
}

void VimeoVideoSelectionWindow::addVideosToAlbum(const QString &id) {
    m_model->addSelectedVideosToAlbum(id);
    this->close();
}

void VimeoVideoSelectionWindow::addVideosToNewAlbum(const QVariantMap &album) {
    m_model->addSelectedVideosToNewAlbum(album);
    this->close();
}

void VimeoVideoSelectionWindow::deleteVideosFromAlbum() {
    m_model->deleteSelectedVideosFromAlbum(m_model->albumId());
    this->close();
}

void VimeoVideoSelectionWindow::addVideosToWatchLaterAlbum() {
    m_model->addSelectedVideosToWatchLaterAlbum();
    this->close();
}

void VimeoVideoSelectionWindow::deleteVideosFromWatchLaterAlbum() {
    m_model->deleteSelectedVideosFromWatchLaterAlbum();
    this->close();
}

void VimeoVideoSelectionWindow::addVideoDownloads() {
    m_model->downloadSelectedVideos();
    this->close();
}

void VimeoVideoSelectionWindow::addAudioDownloads() {
    m_model->downloadSelectedVideos(true);
    this->close();
}

void VimeoVideoSelectionWindow::queueVideos() {
    m_model->queueSelectedVideos();
    this->close();
}
