#include "homewindow.h"
#include "dbusadaptor.h"
#include "../base/utils.h"
#include "../base/session.h"
#include <QApplication>
#include <QTranslator>

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);
    app.setApplicationName("cuteTube");
    app.setApplicationVersion(Utils::versionNumberString());

    Session session;

    if (!session.settings()->language().isEmpty()) {
        QTranslator translator;
        translator.load(QString("/opt/cutetube/translations/cutetube_%1").arg(session.settings()->language()));
        app.installTranslator(&translator);
    }

    HomeWindow window(&session);
    new DBusAdaptor(&window);
    QDBusConnection connection = QDBusConnection::sessionBus();
    connection.registerService("com.maemo.cuteTube");
    connection.registerObject("/", &window);

    window.show();

    return app.exec();
}
