#include "homewindow.h"
#include "aboutdialog.h"
#include "settingsdialog.h"
#include "accountsdialog.h"
#include "searchdialog.h"
#include "youtubecategoriesdialog.h"
#include "dailymotioncategoriesdialog.h"
#include "vimeocategoriesdialog.h"
#include "querydialog.h"
#include "videoservicedialog.h"
#include "linkgoogleaccountdialog.h"
#include "facebookauthdialog.h"
#include "twitterauthdialog.h"
#include "youtubemychannelwindow.h"
#include "dailymotionmychannelwindow.h"
#include "vimeomychannelwindow.h"
#include "youtubevideolistwindow.h"
#include "dailymotionvideolistwindow.h"
#include "youtubeplaylistlistwindow.h"
#include "dailymotionplaylistlistwindow.h"
#include "youtubevideoinfowindow.h"
#include "dailymotionvideoinfowindow.h"
#include "vimeovideoinfowindow.h"
#include "youtubeuserlistwindow.h"
#include "dailymotionuserlistwindow.h"
#include "dailymotiongrouplistwindow.h"
#include "playbackqueuewindow.h"
#include "transferlistwindow.h"
#include "vimeovideolistwindow.h"
#include "socialvideolistwindow.h"
#include "archivewindow.h"
#include "navbutton.h"
#include "../base/feedurls.h"
#include "../base/session.h"
#include <QGridLayout>
#include <QAction>
#include <QMenuBar>

HomeWindow::HomeWindow(Session *session, QWidget *parent) :
    StackedWindow(session, parent),
    m_myChannelButton(new NavButton(tr("My Channel"), ":/images/mychannel.png", this)),
    m_latestButton(new NavButton(tr("Latest Videos"), ":/images/latest.png", this)),
    m_categoriesButton(new NavButton(tr("Categories"), ":/images/categories.png", this)),
    m_socialButton(new NavButton(tr("Social"), ":/images/social.png", this)),
    m_searchButton(new NavButton(tr("Search"), ":/images/search.png", this)),
    m_queueButton(new NavButton(tr("Queue"), ":/images/queue.png", this)),
    m_transfersButton(new NavButton(tr("Transfers"), ":/images/transfers.png", this)),
    m_archiveButton(new NavButton(tr("Archive"), ":/images/archive.png", this)),
    m_accountsButton(new NavButton(tr("Accounts"), ":/images/accounts.png", this)),
    m_accountsAction(this->menuBar()->addAction(tr("Accounts"), this, SLOT(showAccounts()))),
    m_settingsAction(this->menuBar()->addAction(tr("Settings"), this, SLOT(showSettingsDialog()))),
    m_aboutAction(this->menuBar()->addAction(tr("About"), this, SLOT(showAboutDialog()))),
    m_grid(0)
{    
    this->setWindowTitle("cuteTube");
    this->setAttribute(Qt::WA_DeleteOnClose, false);
    this->setCentralWidget(new QWidget(this));
    m_grid = new QGridLayout(centralWidget());
    m_grid->setContentsMargins(0, 0, 0, 0);

    this->connect(m_myChannelButton, SIGNAL(clicked()), this, SLOT(showMyChannel()));
    this->connect(m_latestButton, SIGNAL(clicked()), this, SLOT(showLatestVideos()));
    this->connect(m_categoriesButton, SIGNAL(clicked()), this, SLOT(showCategoriesDialog()));
    this->connect(m_socialButton, SIGNAL(clicked()), this, SLOT(showSocialVideos()));
    this->connect(m_searchButton, SIGNAL(clicked()), this, SLOT(showSearchDialog()));
    this->connect(m_queueButton, SIGNAL(clicked()), this, SLOT(showPlaybackQueue()));
    this->connect(m_transfersButton, SIGNAL(clicked()), this, SLOT(showTransfers()));
    this->connect(m_archiveButton, SIGNAL(clicked()), this, SLOT(showArchive()));
    this->connect(m_accountsButton, SIGNAL(clicked()), this, SLOT(showAccounts()));
    this->connect(m_session->youtube(), SIGNAL(requestToLinkGoogleAccount()), this, SLOT(showLinkGoogleAccountDialog()));
    this->connect(m_session->sharing(), SIGNAL(reauthenticateForFacebook()), this, SLOT(showFacebookAuthDialog()));
    this->connect(m_session->sharing(), SIGNAL(reauthenticateForTwitter()), this, SLOT(showTwitterAuthDialog()));

    this->onOrientationChanged();
}

void HomeWindow::setLandscapeLayout() {
    m_accountsButton->hide();
    m_accountsAction->setEnabled(true);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_myChannelButton, 0, 0);
        m_grid->addWidget(m_latestButton, 0, 1);
        m_grid->addWidget(m_categoriesButton, 0, 2);
        m_grid->addWidget(m_socialButton, 0, 3);
        m_grid->addWidget(m_searchButton, 1, 0);
        m_grid->addWidget(m_queueButton, 1, 1);
        m_grid->addWidget(m_transfersButton, 1, 2);
        m_grid->addWidget(m_archiveButton, 1, 3);
    }
    else {
        m_grid->removeWidget(m_socialButton);
        m_grid->removeWidget(m_searchButton);
        m_grid->removeWidget(m_queueButton);
        m_grid->removeWidget(m_transfersButton);
        m_grid->removeWidget(m_archiveButton);
        m_grid->addWidget(m_socialButton, 0, 3);
        m_grid->addWidget(m_searchButton, 1, 0);
        m_grid->addWidget(m_queueButton, 1, 1);
        m_grid->addWidget(m_transfersButton, 1, 2);
        m_grid->addWidget(m_archiveButton, 1, 3);
    }
}

void HomeWindow::setPortraitLayout() {
    m_accountsButton->show();
    m_accountsAction->setEnabled(false);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_myChannelButton, 0, 0);
        m_grid->addWidget(m_latestButton, 0, 1);
        m_grid->addWidget(m_categoriesButton, 0, 2);
        m_grid->addWidget(m_socialButton, 1, 0);
        m_grid->addWidget(m_searchButton, 1, 1);
        m_grid->addWidget(m_queueButton, 1, 2);
        m_grid->addWidget(m_transfersButton, 2, 0);
        m_grid->addWidget(m_archiveButton, 2, 1);
        m_grid->addWidget(m_accountsButton, 2, 2);
    }
    else {
        m_grid->removeWidget(m_socialButton);
        m_grid->removeWidget(m_searchButton);
        m_grid->removeWidget(m_queueButton);
        m_grid->removeWidget(m_transfersButton);
        m_grid->removeWidget(m_archiveButton);
        m_grid->removeWidget(m_accountsButton);
        m_grid->addWidget(m_socialButton, 1, 0);
        m_grid->addWidget(m_searchButton, 1, 1);
        m_grid->addWidget(m_queueButton, 1, 2);
        m_grid->addWidget(m_transfersButton, 2, 0);
        m_grid->addWidget(m_archiveButton, 2, 1);
        m_grid->addWidget(m_accountsButton, 2, 2);
    }
}

void HomeWindow::showSettingsDialog() {
    SettingsDialog *dialog = new SettingsDialog(m_session, this);
    dialog->open();
}

void HomeWindow::showAboutDialog() {
    AboutDialog *dialog = new AboutDialog(this);
    dialog->open();
}

void HomeWindow::showMyChannel(Services::VideoService service) {
    if (service == Services::NoService) {
        bool signedInToYouTube = m_session->youtube()->userSignedIn();
        bool signedInToDailymotion = m_session->dailymotion()->userSignedIn();
        bool signedInToVimeo = m_session->vimeo()->userSignedIn();
        int accounts = 0;

        if (signedInToYouTube) {
            accounts++;
        }
        if (signedInToDailymotion) {
            accounts++;
        }
        if (signedInToVimeo) {
            accounts++;
        }

        if (accounts > 1) {
            VideoServiceDialog *dialog = new VideoServiceDialog(this);
            dialog->open();
            this->connect(dialog, SIGNAL(valueChanged(Services::VideoService)), this, SLOT(showMyChannel(Services::VideoService)));
        }
        else if (signedInToYouTube) {
            this->showYouTubeChannel();
        }
        else if (signedInToDailymotion) {
            this->showDailymotionChannel();
        }
        else if (signedInToVimeo) {
            this->showVimeoChannel();
        }
        else {
            this->showSignInDialog();
        }
    }
    else if (service == Services::YouTube) {
        this->showYouTubeChannel();
    }
    else if (service == Services::Dailymotion) {
        this->showDailymotionChannel();
    }
    else if (service == Services::Vimeo) {
        this->showVimeoChannel();
    }
}

void HomeWindow::showYouTubeChannel() {
    if (m_session->youtube()->userSignedIn()) {
        YouTubeMyChannelWindow *window = new YouTubeMyChannelWindow(m_session, this);
        window->show();
    }
    else {
        this->showSignInDialog();
    }
}

void HomeWindow::showDailymotionChannel() {
    if (m_session->dailymotion()->userSignedIn()) {
        DailymotionMyChannelWindow *window = new DailymotionMyChannelWindow(m_session, this);
        window->show();
    }
    else {
        this->showSignInDialog();
    }
}

void HomeWindow::showVimeoChannel() {
    if (m_session->vimeo()->userSignedIn()) {
        VimeoMyChannelWindow *window = new VimeoMyChannelWindow(m_session, this);
        window->show();
    }
    else {
        this->showSignInDialog();
    }
}

void HomeWindow::showLatestVideos(Services::VideoService service) {
    if (service == Services::NoService) {
        bool signedInToYouTube = m_session->youtube()->userSignedIn();
        bool signedInToDailymotion = m_session->dailymotion()->userSignedIn();
        bool signedInToVimeo = m_session->vimeo()->userSignedIn();
        int accounts = 0;

        if (signedInToYouTube) {
            accounts++;
        }
        if (signedInToDailymotion) {
            accounts++;
        }
        if (signedInToVimeo) {
            accounts++;
        }

        if (accounts > 1) {
            VideoServiceDialog *dialog = new VideoServiceDialog(this);
            dialog->open();
            this->connect(dialog, SIGNAL(valueChanged(Services::VideoService)), this, SLOT(showLatestVideos(Services::VideoService)));
        }
        else if (signedInToYouTube) {
            this->showLatestYouTubeVideos();
        }
        else if (signedInToDailymotion) {
            this->showLatestDailymotionVideos();
        }
        else if (signedInToVimeo) {
            this->showLatestVimeoVideos();
        }
        else {
            this->showSignInDialog();
        }
    }
    else if (service == Services::YouTube) {
        this->showLatestYouTubeVideos();
    }
    else if (service == Services::Dailymotion) {
        this->showLatestDailymotionVideos();
    }
    else if (service == Services::Vimeo) {
        this->showLatestVimeoVideos();
    }
}

void HomeWindow::showLatestYouTubeVideos() {
    if (m_session->youtube()->userSignedIn()) {
        YouTubeVideoListWindow *window = new YouTubeVideoListWindow(m_session, this);
        window->setVideoFeed(YOUTUBE_NEW_SUBSCRIPTION_VIDEOS_FEED);
        window->setWindowTitle(tr("Latest subscription videos"));
        window->show();
    }
    else {
        this->showSignInDialog();
    }
}

void HomeWindow::showLatestDailymotionVideos() {
    if (m_session->dailymotion()->userSignedIn()) {
        DailymotionVideoListWindow *window = new DailymotionVideoListWindow(m_session, this);
        window->setVideoFeed(DAILYMOTION_NEW_SUBSCRIPTION_VIDEOS_FEED);
        window->setWindowTitle(tr("Latest subscription videos"));
        window->show();
    }
    else {
        this->showSignInDialog();
    }
}

void HomeWindow::showLatestVimeoVideos() {
    if (m_session->vimeo()->userSignedIn()) {
        VimeoVideoListWindow *window = new VimeoVideoListWindow(m_session, this);
        window->setVideoFeed(VIMEO_NEW_SUBSCRIPTION_VIDEOS_FEED);
        window->setWindowTitle(tr("Latest subscription videos"));
        window->show();
    }
    else {
        this->showSignInDialog();
    }
}

void HomeWindow::showCategoriesDialog(Services::VideoService service) {
    if (service == Services::NoService) {
        VideoServiceDialog *dialog = new VideoServiceDialog(this);
        dialog->open();
        this->connect(dialog, SIGNAL(valueChanged(Services::VideoService)), this, SLOT(showCategoriesDialog(Services::VideoService)));
    }
    else if (service == Services::YouTube) {
        YouTubeCategoriesDialog *dialog = new YouTubeCategoriesDialog(this);
        dialog->open();
        this->connect(dialog, SIGNAL(categoryChosen(Services::VideoService,QString,QString)), this, SLOT(showCategoryVideos(Services::VideoService,QString,QString)));
    }
    else if (service == Services::Dailymotion) {
        DailymotionCategoriesDialog *dialog = new DailymotionCategoriesDialog(this);
        dialog->open();
        this->connect(dialog, SIGNAL(categoryChosen(Services::VideoService,QString,QString)), this, SLOT(showCategoryVideos(Services::VideoService,QString,QString)));
    }
    else if (service == Services::Vimeo) {
        VimeoCategoriesDialog *dialog = new VimeoCategoriesDialog(this);
        dialog->open();
        this->connect(dialog, SIGNAL(categoryChosen(Services::VideoService,QString,QString)), this, SLOT(showCategoryVideos(Services::VideoService,QString,QString)));
    }
}

void HomeWindow::showCategoryVideos(Services::VideoService service, const QString &title, const QString &feed) {
    if (service == Services::YouTube) {
        YouTubeVideoListWindow *window = new YouTubeVideoListWindow(m_session, this);
        window->setVideoFeed(feed);
        window->setWindowTitle(title);
        window->show();
    }
    else if (service == Services::Dailymotion) {
        DailymotionVideoListWindow *window = new DailymotionVideoListWindow(m_session, this);
        window->setVideoFeed(feed);
        window->setWindowTitle(title);
        window->show();
    }
    else if (service == Services::Vimeo) {
        VimeoVideoListWindow *window = new VimeoVideoListWindow(m_session, this);
        window->setVideoFeed(feed);
        window->setWindowTitle(title);
        window->show();
    }
}

void HomeWindow::showSocialVideos() {
    if ((m_session->sharing()->userSignedInToFacebook()) || (m_session->sharing()->userSignedInToTwitter())) {
        SocialVideoListWindow *window = new SocialVideoListWindow(m_session, this);
        window->show();
    }
    else {
        this->showSocialSignInDialog();
    }
}

void HomeWindow::showSearchDialog() {
    SearchDialog *dialog = new SearchDialog(m_session, this);
    dialog->open();

    this->connect(dialog, SIGNAL(search(QString)), this, SLOT(search(QString)));
    this->connect(dialog, SIGNAL(goToVideo(QString)), this, SLOT(displayVideo(QString)));
}

void HomeWindow::search(const QString &query) {
    if (m_session->settings()->searchSite() == Services::YouTube) {
        if (m_session->settings()->searchType() == Queries::Videos) {
            YouTubeVideoListWindow *window = new YouTubeVideoListWindow(m_session, this);
            window->search(query, m_session->settings()->searchOrder(), m_session->settings()->searchTime(), m_session->settings()->searchDuration(), m_session->settings()->languageFilter());
            window->show();
        }
        else if (m_session->settings()->searchType() == Queries::Playlists) {
            YouTubePlaylistListWindow *window = new YouTubePlaylistListWindow(m_session, this);
            window->search(query, m_session->settings()->searchOrder());
            window->show();
        }
        else if (m_session->settings()->searchType() == Queries::Users) {
            YouTubeUserListWindow *window = new YouTubeUserListWindow(m_session, this);
            window->search(query);
            window->show();
        }
    }
    else if (m_session->settings()->searchSite() == Services::Dailymotion) {
        if (m_session->settings()->searchType() == Queries::Videos) {
            DailymotionVideoListWindow *window = new DailymotionVideoListWindow(m_session, this);
            window->search(query, m_session->settings()->searchOrder(), m_session->settings()->languageFilter());
            window->show();
        }
        else if (m_session->settings()->searchType() == Queries::Playlists) {
            DailymotionPlaylistListWindow *window = new DailymotionPlaylistListWindow(m_session, this);
            window->search(query, m_session->settings()->searchOrder());
            window->show();
        }
        else if (m_session->settings()->searchType() == Queries::Users) {
            DailymotionUserListWindow *window = new DailymotionUserListWindow(m_session, this);
            window->search(query);
            window->show();
        }
        else if (m_session->settings()->searchType() == Queries::Groups) {
            DailymotionGroupListWindow *window = new DailymotionGroupListWindow(m_session, this);
            window->search(query, m_session->settings()->searchOrder());
            window->show();
        }
    }
    else if (m_session->settings()->searchSite() == Services::Vimeo) {
        VimeoVideoListWindow *window = new VimeoVideoListWindow(m_session, this);
        window->search(query, m_session->settings()->searchOrder());
        window->show();
    }
}

void HomeWindow::displayVideo(const QString &url) {
    m_session->unwindWindowStack();
    this->activateWindow();

    if (url.contains(QRegExp("youtube|youtu.be"))) {
        m_session->youtube()->getFullVideo(url);
        this->connect(m_session->youtube(), SIGNAL(gotVideo(QSharedPointer<VideoItem>)), this, SLOT(showYouTubeVideo(QSharedPointer<VideoItem>)));
    }
    else if (url.contains(QRegExp("dailymotion|dai.ly"))) {
        m_session->dailymotion()->getFullVideo(url);
        this->connect(m_session->dailymotion(), SIGNAL(gotVideo(QSharedPointer<VideoItem>)), this, SLOT(showDailymotionVideo(QSharedPointer<VideoItem>)));
    }
    else if (url.contains("vimeo")) {
        m_session->vimeo()->getFullVideo(url);
        this->connect(m_session->vimeo(), SIGNAL(gotVideo(QSharedPointer<VideoItem>)), this, SLOT(showVimeoVideo(QSharedPointer<VideoItem>)));
    }
}

void HomeWindow::playVideo(const QString &url) {
    Q_UNUSED(url);

    this->activateWindow();
}

void HomeWindow::showYouTubeVideo(QSharedPointer<VideoItem> video) {
    YouTubeVideoInfoWindow *window = new YouTubeVideoInfoWindow(m_session, video, this);
    window->show();

    this->disconnect(m_session->youtube(), SIGNAL(gotVideo(QSharedPointer<VideoItem>)), this, SLOT(showYouTubeVideo(QSharedPointer<VideoItem>)));
}

void HomeWindow::showDailymotionVideo(QSharedPointer<VideoItem> video) {
    DailymotionVideoInfoWindow *window = new DailymotionVideoInfoWindow(m_session, video, this);
    window->show();

    this->disconnect(m_session->dailymotion(), SIGNAL(gotVideo(QSharedPointer<VideoItem>)), this, SLOT(showDailymotionVideo(QSharedPointer<VideoItem>)));
}

void HomeWindow::showVimeoVideo(QSharedPointer<VideoItem> video) {
    VimeoVideoInfoWindow *window = new VimeoVideoInfoWindow(m_session, video, this);
    window->show();

    this->disconnect(m_session->vimeo(), SIGNAL(gotVideo(QSharedPointer<VideoItem>)), this, SLOT(showVimeoVideo(QSharedPointer<VideoItem>)));
}

void HomeWindow::showPlaybackQueue() {
    PlaybackQueueWindow *window = new PlaybackQueueWindow(m_session, this);
    window->show();
}

void HomeWindow::showTransfers() {
    TransferListWindow *window = new TransferListWindow(m_session, this);
    window->show();
}

void HomeWindow::showArchive() {
    ArchiveWindow *window = new ArchiveWindow(m_session, this);
    window->show();
}

void HomeWindow::showAccounts() {
    AccountsDialog *dialog = new AccountsDialog(m_session, this);
    dialog->open();
}

void HomeWindow::showSignInDialog() {
    QueryDialog *dialog = new QueryDialog(this);
    dialog->setWindowTitle(tr("Sign in?"));
    dialog->setMessage(tr("You are not signed in to an account. Would you like to sign in now?"));
    dialog->open();

    this->connect(dialog, SIGNAL(accepted()), this, SLOT(showAccounts()));
}

void HomeWindow::showSocialSignInDialog() {
    QueryDialog *dialog = new QueryDialog(this);
    dialog->setWindowTitle(tr("Sign in?"));
    dialog->setMessage(tr("This feature requires you to be signed in to a facebook or twitter account. Would you like to sign in now?"));
    dialog->open();

    this->connect(dialog, SIGNAL(accepted()), this, SLOT(showAccounts()));
}

void HomeWindow::showLinkGoogleAccountDialog() {
    LinkGoogleAccountDialog *dialog = new LinkGoogleAccountDialog(m_session, this);
    dialog->show();
}

void HomeWindow::showFacebookAuthDialog() {
    FacebookAuthDialog *dialog = new FacebookAuthDialog(m_session, this);
    dialog->open();
}

void HomeWindow::showTwitterAuthDialog() {
    TwitterAuthDialog *dialog = new TwitterAuthDialog(m_session, this);
    dialog->open();
}
