#include "dailymotionuserlisttab.h"
#include "dailymotionuserlistdelegate.h"
#include "dailymotionvideolistwindow.h"
#include "dailymotionchannelwindow.h"
#include "../base/dailymotionuserlistmodel.h"
#include "../base/session.h"
#include "listview.h"
#include <QLabel>
#include <QGridLayout>
#include <QAction>

DailymotionUserListTab::DailymotionUserListTab(Session *session, const QString &userId, QWidget *parent) :
    AbstractTab(parent),
    m_session(session),
    m_userId(userId),
    m_model(new DailymotionUserListModel(m_session, this)),
    m_listView(new ListView(this)),
    m_videosAction(new QAction(tr("Latest videos"), this)),
    m_noResultsLabel(new QLabel(QString("<p style='color:#4d4d4d;font-size:40px;'><center><b>%1</b></center></p>").arg(tr("No subscriptions found")), this)),
    m_grid(new QGridLayout(this))
{
    this->addAction(m_videosAction);

    m_grid->setContentsMargins(0, 0, 0, 0);
    m_grid->addWidget(m_listView, 0, 0);
    m_listView->setModel(m_model);
    m_listView->setItemDelegate(new DailymotionUserListDelegate(m_listView));
    m_noResultsLabel->hide();

    this->connect(m_model, SIGNAL(loadingChanged(bool)), this, SLOT(onLoadingChanged(bool)));
    this->connect(m_model, SIGNAL(countChanged(int)), this, SLOT(onCountChanged(int)));
    this->connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    this->connect(m_listView, SIGNAL(atEnd()), m_model, SLOT(getMoreUsers()));
    this->connect(m_videosAction, SIGNAL(triggered()), this, SLOT(showSubscriptionVideos()));

    this->onOrientationChanged();
}

void DailymotionUserListTab::setFeed(const QString &feed) {
    m_model->getUsers(feed);
}

void DailymotionUserListTab::setLandscapeLayout() {
    m_noResultsLabel->setFixedSize(800, 400);
}

void DailymotionUserListTab::setPortraitLayout() {
    m_noResultsLabel->setFixedSize(480, 700);
}

void DailymotionUserListTab::onLoadingChanged(bool loading) {
    m_session->toggleBusy(loading);
    m_noResultsLabel->setVisible((!loading) && (m_model->rowCount() == 0));
}

void DailymotionUserListTab::onCountChanged(int count) {
    m_noResultsLabel->setVisible((count == 0) && (!m_model->loading()));
}

void DailymotionUserListTab::onItemClicked(const QModelIndex &index) {
    if (index.isValid()) {
        this->showUserChannel(index.data(AbstractUserListModel::IdRole).toString());
    }
}

void DailymotionUserListTab::showUserChannel(const QString &userId) {
    DailymotionChannelWindow *window = new DailymotionChannelWindow(m_session, userId, m_session->currentWindow());
    window->show();
}

void DailymotionUserListTab::showSubscriptionVideos() {
    DailymotionVideoListWindow *window = new DailymotionVideoListWindow(m_session, m_session->currentWindow());
    window->setVideoFeed(QString("https://api.dailymotion.com/users/%1/subscriptions?limit=30").arg(m_userId));
}
