#include "aboutdialog.h"
#include "../base/utils.h"
#include <QLabel>
#include <QPushButton>
#include <QDialogButtonBox>
#include <QGridLayout>
#include <QDesktopServices>
#include <QUrl>
#include <QPixmap>

AboutDialog::AboutDialog(QWidget *parent) :
    AbstractDialog(parent),
    m_icon(new QLabel(this)),
    m_title(new QLabel("cuteTube " + Utils::versionNumberString(), this)),
    m_details(new QLabel(tr("A fully-featured client for YouTube, Dailymotion and Vimeo.") + "<br><br> &copy; Stuart Howarth 2010-2013", this)),
    m_buttonBox(new QDialogButtonBox(Qt::Vertical, this)),
    m_donateButton(m_buttonBox->addButton(tr("Donate"), QDialogButtonBox::ActionRole)),
    m_bugButton(m_buttonBox->addButton(tr("Report bug"), QDialogButtonBox::ActionRole)),
    m_grid(new QGridLayout(this))
{
    this->setWindowTitle(tr("About"));
    m_icon->setPixmap(QPixmap(":/images/cutetube.png"));
    m_icon->setFixedWidth(m_icon->pixmap()->width() + 10);
    QFont font;
    font.setBold(true);
    font.setPixelSize(32);
    m_title->setFont(font);
    m_details->setWordWrap(true);
    this->connect(m_donateButton, SIGNAL(clicked()), this, SLOT(donate()));
    this->connect(m_bugButton, SIGNAL(clicked()), this, SLOT(reportBug()));

    this->onOrientationChanged();
}

void AboutDialog::setLandscapeLayout() {
    this->setFixedHeight(220);
    m_buttonBox->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_icon, 0, 0);
        m_grid->addWidget(m_title, 0, 1);
        m_grid->addWidget(m_details, 1, 0, 1, 2, Qt::AlignBottom);
        m_grid->addWidget(m_buttonBox, 1, 2);
    }
    else {
        m_grid->setAlignment(m_details, Qt::AlignBottom);
        m_grid->removeWidget(m_buttonBox);
        m_grid->addWidget(m_buttonBox, 1, 2);
    }
}

void AboutDialog::setPortraitLayout() {
    this->setFixedHeight(400);
    m_buttonBox->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_icon, 0, 0);
        m_grid->addWidget(m_title, 0, 1);
        m_grid->addWidget(m_details, 1, 0, 1, 2, Qt::AlignHCenter);
        m_grid->addWidget(m_buttonBox, 2, 0, 1, 2);
    }
    else {
        m_grid->setAlignment(m_details, Qt::AlignHCenter);
        m_grid->removeWidget(m_buttonBox);
        m_grid->addWidget(m_buttonBox, 2, 0, 1, 2);
    }
}

void AboutDialog::donate() {
    QDesktopServices::openUrl(QUrl("https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=stuhowarth77@gmail.com&lc=GB&item_name=cuteTube&currency_code=USD&bn=PP%2dDonationsBF%3abtn_donate_SM%2egif%3aNonHosted"));
    this->close();
}

void AboutDialog::reportBug() {
    QDesktopServices::openUrl(QUrl("mailto:showarth@cutetube.co.uk?subject=cuteTube for N900"));
    this->close();
}
