#ifndef SETTINGS_H
#define SETTINGS_H

#include "enums.h"
#include <QSettings>
#include <QStringList>
#include <QSet>

class QNetworkProxy;
class QAuthenticator;

class Settings : public QSettings
{
    Q_OBJECT

    Q_PROPERTY(bool enableYouTube1080Playback
               READ enableYouTube1080Playback
               WRITE setEnableYouTube1080Playback
               NOTIFY enableYouTube1080PlaybackChanged)
    Q_PROPERTY(bool enableYouTube720Playback
               READ enableYouTube720Playback
               WRITE setEnableYouTube720Playback
               NOTIFY enableYouTube720PlaybackChanged)
    Q_PROPERTY(bool enableYouTube480Playback
               READ enableYouTube480Playback
               WRITE setEnableYouTube480Playback
               NOTIFY enableYouTube480PlaybackChanged)
    Q_PROPERTY(bool enableYouTube360Playback
               READ enableYouTube360Playback
               WRITE setEnableYouTube360Playback
               NOTIFY enableYouTube360PlaybackChanged)
    Q_PROPERTY(bool enableYouTube1080Download
               READ enableYouTube1080Download
               WRITE setEnableYouTube1080Download
               NOTIFY enableYouTube1080DownloadChanged)
    Q_PROPERTY(bool enableYouTube720Download
               READ enableYouTube720Download
               WRITE setEnableYouTube720Download
               NOTIFY enableYouTube720DownloadChanged)
    Q_PROPERTY(bool enableYouTube480Download
               READ enableYouTube480Download
               WRITE setEnableYouTube480Download
               NOTIFY enableYouTube480DownloadChanged)
    Q_PROPERTY(bool enableYouTube360Download
               READ enableYouTube360Download
               WRITE setEnableYouTube360Download
               NOTIFY enableYouTube360DownloadChanged)
    Q_PROPERTY(bool enableDailymotion720Playback
               READ enableDailymotion720Playback
               WRITE setEnableDailymotion720Playback
               NOTIFY enableDailymotion720PlaybackChanged)
    Q_PROPERTY(bool enableDailymotion480Playback
               READ enableDailymotion480Playback
               WRITE setEnableDailymotion480Playback
               NOTIFY enableDailymotion480PlaybackChanged)
    Q_PROPERTY(bool enableDailymotion720Download
               READ enableDailymotion720Download
               WRITE setEnableDailymotion720Download
               NOTIFY enableDailymotion720DownloadChanged)
    Q_PROPERTY(bool enableDailymotion480Download
               READ enableDailymotion480Download
               WRITE setEnableDailymotion480Download
               NOTIFY enableDailymotion480DownloadChanged)
    Q_PROPERTY(bool enableVimeo720Playback
               READ enableVimeo720Playback
               WRITE setEnableVimeo720Playback
               NOTIFY enableVimeo720PlaybackChanged)
    Q_PROPERTY(bool enableVimeo360Playback
               READ enableVimeo360Playback
               WRITE setEnableVimeo360Playback
               NOTIFY enableVimeo360PlaybackChanged)
    Q_PROPERTY(bool enableVimeo720Download
               READ enableVimeo720Download
               WRITE setEnableVimeo720Download
               NOTIFY enableVimeo720DownloadChanged)
    Q_PROPERTY(bool enableVimeo360Download
               READ enableVimeo360Download
               WRITE setEnableVimeo360Download
               NOTIFY enableVimeo360DownloadChanged)
    Q_PROPERTY(QString downloadPath
               READ downloadPath
               WRITE setDownloadPath
               NOTIFY downloadPathChanged)
    Q_PROPERTY(bool startTransfersAutomatically
               READ startTransfersAutomatically
               WRITE setStartTransfersAutomatically
               NOTIFY startTransfersAutomaticallyChanged)
    Q_PROPERTY(int maximumConcurrentTransfers
               READ maximumConcurrentTransfers
               WRITE setMaximumConcurrentTransfers
               NOTIFY maximumConcurrentTransfersChanged)
    Q_PROPERTY(bool safeSearch
               READ safeSearch
               WRITE setSafeSearch
               NOTIFY safeSearchChanged)
    Q_PROPERTY(Services::VideoService searchSite
               READ searchSite
               WRITE setSearchSite
               NOTIFY searchSiteChanged)
    Q_PROPERTY(bool showSearchSite
               READ showSearchSite
               WRITE setShowSearchSite
               NOTIFY showSearchSiteChanged)
    Q_PROPERTY(Queries::QueryOrder searchOrder
               READ searchOrder
               WRITE setSearchOrder
               NOTIFY searchOrderChanged)
    Q_PROPERTY(bool showSearchOrder
               READ showSearchOrder
               WRITE setShowSearchOrder
               NOTIFY showSearchOrderChanged)
    Q_PROPERTY(Queries::TimeFilter searchTime
               READ searchTime
               WRITE setSearchTime
               NOTIFY searchTimeChanged)
    Q_PROPERTY(bool showSearchTime
               READ showSearchTime
               WRITE setShowSearchTime
               NOTIFY showSearchTimeChanged)
    Q_PROPERTY(Queries::DurationFilter searchDuration
               READ searchDuration
               WRITE setSearchDuration
               NOTIFY searchDurationChanged)
    Q_PROPERTY(bool showSearchDuration
               READ showSearchDuration
               WRITE setShowSearchDuration
               NOTIFY showSearchDurationChanged)
    Q_PROPERTY(Queries::QueryType searchType
               READ searchType
               WRITE setSearchType
               NOTIFY searchTypeChanged)
    Q_PROPERTY(bool showSearchType
               READ showSearchType
               WRITE setShowSearchType
               NOTIFY showSearchTypeChanged)
    Q_PROPERTY(QString languageFilter
               READ languageFilter
               WRITE setLanguageFilter
               NOTIFY languageFilterChanged)
    Q_PROPERTY(bool showSearchLanguage
               READ showSearchLanguage
               WRITE setShowSearchLanguage
               NOTIFY showSearchLanguageChanged)
    Q_PROPERTY(QString theme
               READ theme
               WRITE setTheme
               NOTIFY themeChanged)
    Q_PROPERTY(QString activeColor
               READ activeColor
               WRITE setActiveColor
               NOTIFY activeColorChanged)
    Q_PROPERTY(QString activeColorString
               READ activeColorString
               WRITE setActiveColorString
               NOTIFY activeColorStringChanged)
    Q_PROPERTY(QString language
               READ language
               WRITE setLanguage
               NOTIFY languageChanged)
    Q_PROPERTY(ScreenOrientation::Orientation screenOrientation
               READ screenOrientation
               WRITE setScreenOrientation
               NOTIFY screenOrientationChanged)
    Q_PROPERTY(QString uploadAttribute
               READ uploadAttribute
               WRITE setUploadAttribute
               NOTIFY uploadAttributeChanged)
    Q_PROPERTY(QString mediaPlayer
               READ mediaPlayer
               WRITE setMediaPlayer
               NOTIFY mediaPlayerChanged)
    Q_PROPERTY(QString mediaPlayerCommand
               READ mediaPlayerCommand
               WRITE setMediaPlayerCommand
               NOTIFY mediaPlayerCommandChanged)
    Q_PROPERTY(bool backgroundPlaybackEnabled
               READ backgroundPlaybackEnabled
               WRITE setBackgroundPlaybackEnabled
               NOTIFY backgroundPlaybackEnabledChanged)
    Q_PROPERTY(bool monitorClipboard
               READ monitorClipboard
               WRITE setMonitorClipboard
               NOTIFY monitorClipboardChanged)
    Q_PROPERTY(NetworkProxyType::ProxyType networkProxyType
               READ networkProxyType
               WRITE setNetworkProxyType
               NOTIFY networkProxyTypeChanged)
    Q_PROPERTY(QString networkProxyTypeString
               READ networkProxyTypeString
               NOTIFY networkProxyTypeStringChanged)
    Q_PROPERTY(QString networkProxyHostName
               READ networkProxyHostName
               WRITE setNetworkProxyHostName
               NOTIFY networkProxyHostNameChanged)
    Q_PROPERTY(quint16 networkProxyPort
               READ networkProxyPort
               WRITE setNetworkProxyPort
               NOTIFY networkProxyPortChanged)
    Q_PROPERTY(QString networkProxyUser
               READ networkProxyUser
               WRITE setNetworkProxyUser
               NOTIFY networkProxyUserChanged)
    Q_PROPERTY(QString networkProxyPassword
               READ networkProxyPassword
               WRITE setNetworkProxyPassword
               NOTIFY networkProxyPasswordChanged)
    Q_PROPERTY(bool eventFeedEnabled
               READ eventFeedEnabled
               WRITE setEventFeedEnabled
               NOTIFY eventFeedEnabledChanged)
    Q_PROPERTY(bool eventFeedInstalled
               READ eventFeedInstalled
               CONSTANT)
    Q_PROPERTY(bool cuteTubePlayerEnabled
               READ cuteTubePlayerEnabled
               CONSTANT)

public:
    explicit Settings(QObject *parent = 0);
    ~Settings();
    inline QSet<int> youtubePlaybackSet() const { return m_youtubePlaybackSet; }
    inline QSet<int> youtubeDownloadSet() const { return m_youtubeDownloadSet; }
    inline QSet<QByteArray> dailymotionPlaybackSet() const { return m_dailymotionPlaybackSet; }
    inline QSet<QByteArray> dailymotionDownloadSet() const { return m_dailymotionDownloadSet; }
    inline QSet<QByteArray> vimeoPlaybackSet() const { return m_vimeoPlaybackSet; }
    inline QSet<QByteArray> vimeoDownloadSet() const { return m_vimeoDownloadSet; }
    inline bool enableYouTube1080Playback() const { return m_youtubePlaybackSet.contains(37); }
    inline bool enableYouTube720Playback() const { return m_youtubePlaybackSet.contains(22); }
    inline bool enableYouTube480Playback() const { return m_youtubePlaybackSet.contains(35); }
    inline bool enableYouTube360Playback() const { return m_youtubePlaybackSet.contains(34); }
    inline bool enableYouTube1080Download() const { return m_youtubeDownloadSet.contains(37); }
    inline bool enableYouTube720Download() const { return m_youtubeDownloadSet.contains(22); }
    inline bool enableYouTube480Download() const { return m_youtubeDownloadSet.contains(35); }
    inline bool enableYouTube360Download() const { return m_youtubeDownloadSet.contains(34); }
    inline bool enableDailymotion720Playback() const { return m_dailymotionPlaybackSet.contains("hd720URL"); }
    inline bool enableDailymotion480Playback() const { return m_dailymotionPlaybackSet.contains("hqURL"); }
    inline bool enableDailymotion720Download() const { return m_dailymotionDownloadSet.contains("hd720URL"); }
    inline bool enableDailymotion480Download() const { return m_dailymotionDownloadSet.contains("hqURL"); }
    inline bool enableVimeo720Playback() const { return m_vimeoPlaybackSet.contains("hd"); }
    inline bool enableVimeo360Playback() const { return m_vimeoPlaybackSet.contains("sd"); }
    inline bool enableVimeo720Download() const { return m_vimeoDownloadSet.contains("hd"); }
    inline bool enableVimeo360Download() const { return m_vimeoDownloadSet.contains("sd"); }
    inline bool startTransfersAutomatically() const { return m_autoTransfers; }
    inline int maximumConcurrentTransfers() const { return m_maxConcurrentTransfers; }
    inline QString downloadPath() const { return m_path; }
    inline bool safeSearch() { return m_safeSearch; }
    inline Services::VideoService searchSite() const { return this->showSearchSite() ? m_searchSite : Services::YouTube; }
    inline bool showSearchSite() const { return m_showSearchSite; }
    inline Queries::QueryOrder searchOrder() const { return this->showSearchOrder() ? m_searchOrder : Queries::Relevance; }
    inline bool showSearchOrder() const { return m_showSearchOrder; }
    inline Queries::TimeFilter searchTime() const { return this->showSearchTime() ? m_searchTime : Queries::AllTime; }
    inline bool showSearchTime() const { return m_showSearchTime; }
    inline Queries::DurationFilter searchDuration() const { return this->showSearchDuration() ? m_searchDuration : Queries::Any; }
    inline bool showSearchDuration() const { return m_showSearchDuration; }
    inline Queries::QueryType searchType() const { return this->showSearchType() ? m_searchType : Queries::Videos; }
    inline bool showSearchType() const { return m_showSearchType; }
    inline QString languageFilter() const { return m_languageFilter; }
    inline bool showSearchLanguage() const { return m_showSearchLanguage; }
    inline QString theme() const { return m_theme; }
    inline QString activeColor() const { return m_activeColor; }
    inline QString activeColorString() const { return m_activeColorString; }
    inline QString language() const { return m_language; }
    inline QString uploadAttribute() const { return m_attribute; }
    inline QString mediaPlayer() const { return m_mediaplayer; }
    inline QString mediaPlayerCommand() const { return m_command; }
    inline bool backgroundPlaybackEnabled() const { return m_backgroundPlaybackEnabled; }
    inline ScreenOrientation::Orientation screenOrientation() const { return m_orientation; }
    inline bool monitorClipboard() const { return m_monitorClipboard; }
    inline NetworkProxyType::ProxyType networkProxyType() const { return m_proxyType; }
    QString networkProxyTypeString() const;
    inline QString networkProxyHostName() const { return m_proxyHost; }
    inline quint16 networkProxyPort() const { return m_proxyPort; }
    inline QString networkProxyUser() const { return m_proxyUser; }
    inline QString networkProxyPassword() const { return m_proxyPass; }
    inline bool eventFeedEnabled() const { return m_eventFeedEnabled; }
    bool eventFeedInstalled() const;
    inline bool cuteTubePlayerEnabled() const { return m_cuteTubePlayerEnabled; }

public slots:
    void saveSettings();
    void restoreSettings();
    void setEnableYouTube1080Playback(bool enable);
    void setEnableYouTube720Playback(bool enable);
    void setEnableYouTube480Playback(bool enable);
    void setEnableYouTube360Playback(bool enable);
    void setEnableYouTube1080Download(bool enable);
    void setEnableYouTube720Download(bool enable);
    void setEnableYouTube480Download(bool enable);
    void setEnableYouTube360Download(bool enable);
    void setEnableDailymotion720Playback(bool enable);
    void setEnableDailymotion480Playback(bool enable);
    void setEnableDailymotion720Download(bool enable);
    void setEnableDailymotion480Download(bool enable);
    void setEnableVimeo720Playback(bool enable);
    void setEnableVimeo360Playback(bool enable);
    void setEnableVimeo720Download(bool enable);
    void setEnableVimeo360Download(bool enable);
    void setStartTransfersAutomatically(bool automatic);
    void setMaximumConcurrentTransfers(int maximum);
    void setDownloadPath(const QString &path);
    void setSafeSearch(bool safe);
    void setSearchSite(Services::VideoService site);
    void setShowSearchSite(bool show);
    void setSearchOrder(Queries::QueryOrder order);
    void setShowSearchOrder(bool show);
    void setSearchTime(Queries::TimeFilter time);
    void setShowSearchTime(bool show);
    void setSearchDuration(Queries::DurationFilter duration);
    void setShowSearchDuration(bool show);
    void setSearchType(Queries::QueryType type);
    void setShowSearchType(bool show);
    void setLanguageFilter(const QString &language);
    void setShowSearchLanguage(bool show);
    void setTheme(const QString &theme);
    void setActiveColor(const QString &color);
    void setActiveColorString(const QString &colorString);
    void setLanguage(const QString &lang);
    void setUploadAttribute(const QString &attribute);
    void setMediaPlayer(const QString &player);
    void setMediaPlayerCommand(const QString &command);
    void setBackgroundPlaybackEnabled(bool enabled);
    void setScreenOrientation(ScreenOrientation::Orientation orientation);
    void setMonitorClipboard(bool monitor);
    void setNetworkProxyType(NetworkProxyType::ProxyType proxyType);
    void setNetworkProxyHostName(const QString &hostName);
    void setNetworkProxyPort(quint16 port);
    void setNetworkProxyUser(const QString &user);
    void setNetworkProxyPassword(const QString &password);
    void setNetworkProxy();
    void setEventFeedEnabled(bool enabled);

private:
    void setYouTubePlaybackQualitySet(const QVariantList &qualityList);
    void setYouTubeDownloadQualitySet(const QVariantList &qualityList);
    void setDailymotionPlaybackQualitySet(const QVariantList &qualityList);
    void setDailymotionDownloadQualitySet(const QVariantList &qualityList);
    void setVimeoPlaybackQualitySet(const QVariantList &qualityList);
    void setVimeoDownloadQualitySet(const QVariantList &qualityList);
    QVariantList toVariantList(const QSet<int> &set);
    QVariantList toVariantList(const QSet<QByteArray> &set);
    void setCuteTubePlayerEnabled();

private slots:
    void onNetworkProxyAuthenticationRequested(const QNetworkProxy &proxy, QAuthenticator *authenticator);

signals:
    void enableYouTube1080PlaybackChanged();
    void enableYouTube720PlaybackChanged();
    void enableYouTube480PlaybackChanged();
    void enableYouTube360PlaybackChanged();
    void enableYouTube1080DownloadChanged();
    void enableYouTube720DownloadChanged();
    void enableYouTube480DownloadChanged();
    void enableYouTube360DownloadChanged();
    void enableDailymotion720PlaybackChanged();
    void enableDailymotion480PlaybackChanged();
    void enableDailymotion720DownloadChanged();
    void enableDailymotion480DownloadChanged();
    void enableVimeo720PlaybackChanged();
    void enableVimeo360PlaybackChanged();
    void enableVimeo720DownloadChanged();
    void enableVimeo360DownloadChanged();
    void youtubePlaybackQualityChanged(const QSet<int> &qualitySet);
    void youtubeDownloadQualityChanged(const QSet<int> &qualitySet);
    void dailymotionPlaybackQualityChanged(const QSet<QByteArray> &qualitySet);
    void dailymotionDownloadQualityChanged(const QSet<QByteArray> &qualitySet);
    void vimeoPlaybackQualityChanged(const QSet<QByteArray> &qualitySet);
    void vimeoDownloadQualityChanged(const QSet<QByteArray> &qualitySet);
    void startTransfersAutomaticallyChanged(bool automatic);
    void maximumConcurrentTransfersChanged(int oldMaximum, int newMaximum);
    void downloadPathChanged(const QString &path);
    void safeSearchChanged(bool safe);
    void searchSiteChanged(Services::VideoService service);
    void showSearchSiteChanged(bool show);
    void searchOrderChanged(Queries::QueryOrder order);
    void showSearchOrderChanged(bool show);
    void searchTimeChanged(Queries::TimeFilter time);
    void showSearchTimeChanged(bool show);
    void searchDurationChanged(Queries::DurationFilter duration);
    void showSearchDurationChanged(bool show);
    void searchTypeChanged(Queries::QueryType type);
    void showSearchTypeChanged(bool show);
    void languageFilterChanged(const QString &language);
    void showSearchLanguageChanged(bool show);
    void themeChanged(const QString &theme);
    void activeColorChanged(const QString &color);
    void activeColorStringChanged(const QString &colorString);
    void languageChanged(const QString &language);
    void alert(const QString &message);
    void uploadAttributeChanged(const QString &attribute);
    void mediaPlayerChanged(const QString &player);
    void mediaPlayerCommandChanged(const QString &command);
    void backgroundPlaybackEnabledChanged(bool enabled);
    void screenOrientationChanged(ScreenOrientation::Orientation orientation);
    void monitorClipboardChanged(bool monitor);
    void networkProxyTypeChanged(NetworkProxyType::ProxyType proxyType);
    void networkProxyTypeStringChanged(const QString &proxyTypeString);
    void networkProxyHostNameChanged(const QString &hostName);
    void networkProxyPortChanged(quint16 port);
    void networkProxyUserChanged(const QString &user);
    void networkProxyPasswordChanged(const QString &password);
    void eventFeedEnabledChanged(bool enabled);

private:
    QSet<int> m_youtubePlaybackSet;
    QSet<int> m_youtubeDownloadSet;
    QSet<QByteArray> m_dailymotionPlaybackSet;
    QSet<QByteArray> m_dailymotionDownloadSet;
    QSet<QByteArray> m_vimeoPlaybackSet;
    QSet<QByteArray> m_vimeoDownloadSet;
    bool m_autoTransfers;
    int m_maxConcurrentTransfers;
    QString m_path;
    bool m_safeSearch;
    Services::VideoService m_searchSite;
    bool m_showSearchSite;
    Queries::QueryOrder m_searchOrder;
    bool m_showSearchOrder;
    Queries::TimeFilter m_searchTime;
    bool m_showSearchTime;
    Queries::DurationFilter m_searchDuration;
    bool m_showSearchDuration;
    Queries::QueryType m_searchType;
    bool m_showSearchType;
    QString m_languageFilter;
    bool m_showSearchLanguage;
    QString m_theme;
    QString m_activeColor;
    QString m_activeColorString;
    QString m_language;
    QString m_attribute;
    QString m_mediaplayer;
    QString m_command;
    bool m_backgroundPlaybackEnabled;
    ScreenOrientation::Orientation m_orientation;
    bool m_monitorClipboard;
    NetworkProxyType::ProxyType m_proxyType;
    QString m_proxyTypeString;
    QString m_proxyHost;
    quint16 m_proxyPort;
    QString m_proxyUser;
    QString m_proxyPass;
    bool m_eventFeedEnabled;
    bool m_eventFeedInstalled;
    bool m_cuteTubePlayerEnabled;
};

#endif // SETTINGS_H
