#ifndef DAILYMOTIONUSERPLAYLISTLISTMODEL_H
#define DAILYMOTIONUSERPLAYLISTLISTMODEL_H

#include "playlistitem.h"
#include <QAbstractListModel>
#include <QSharedPointer>

class Session;

class DailymotionUserPlaylistListModel : public QAbstractListModel
{
    Q_OBJECT

    Q_PROPERTY(Session* session
               READ session
               WRITE setSession)
    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

public:
    enum Roles {
        IdRole = Qt::UserRole + 1,
        PlaylistIdRole,
        TitleRole,
        ArtistRole,
        DateRole,
        VideoCountRole,
        DescriptionRole
    };

public:
    explicit DailymotionUserPlaylistListModel(Session *session = 0, QObject *parent = 0);
    ~DailymotionUserPlaylistListModel() {}
    inline Session* session() const { return m_session; }
    void setSession(Session *session);
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role = Qt::DisplayRole) const;
    Q_INVOKABLE QVariant data(int row, const QByteArray &role) const;
    QSharedPointer<PlaylistItem> get(int row) const;
    Q_INVOKABLE PlaylistItem* getFromQML(int row) const;

private slots:
    void onPlaylistAdded(int row);
    void onPlaylistRemoved(int row);
    void onPlaylistUpdated(int row);

signals:
    void countChanged(int count);

private:
    Session *m_session;
};

#endif // DAILYMOTIONUSERPLAYLISTLISTMODEL_H
