#ifndef ABSTRACTCOMMENTLISTMODEL_H
#define ABSTRACTCOMMENTLISTMODEL_H

#include "commentitem.h"
#include <QAbstractListModel>
#include <QSharedPointer>

class ThumbnailCache;

class AbstractCommentListModel : public QAbstractListModel
{
    Q_OBJECT

public:
    enum Roles {
        IdRole = Qt::UserRole + 1,
        BodyRole,
        ArtistRole,
        ArtistIdRole,
        ArtistAvatarRole,
        ArtistAvatarUrlRole,
        DateRole,
        VideoIdRole,
        ReplyIdRole,
        IndentRole,
        LoadingRole,
        AvatarPressedRole,
        LoaderPressedRole
    };

public:
    explicit AbstractCommentListModel(ThumbnailCache *cache = 0, QObject *parent = 0);
    ~AbstractCommentListModel();
    inline ThumbnailCache* thumbnailCache() const { return m_cache; }
    void setThumbnailCache(ThumbnailCache *cache);
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role) const;
    Q_INVOKABLE QVariant data(int row, const QByteArray &role) const;
    bool setData(const QModelIndex &index, const QVariant &value, int role);
    QSharedPointer<CommentItem> get(int row) const;
    Q_INVOKABLE CommentItem* getFromQML(int row) const;
    void insertComment(int row, QSharedPointer<CommentItem> comment);
    void appendComment(QSharedPointer<CommentItem> comment);
    bool removeComment(const QVariant &value, int role = IdRole);

public slots:
    void clear();
    
protected:
    bool removeRow(int row, const QModelIndex &parent = QModelIndex());

protected slots:
    void onThumbnailReady();

protected:
    ThumbnailCache *m_cache;
    QList< QSharedPointer<CommentItem> > m_list;
    int m_avatarPressedRow;
    int m_loaderPressedRow;
};

#endif // ABSTRACTCOMMENTLISTMODEL_H
