#ifndef YOUTUBEUSERPLAYLISTLISTMODEL_H
#define YOUTUBEUSERPLAYLISTLISTMODEL_H

#include "session.h"
#include <QAbstractListModel>

class YouTubeUserPlaylistListModel : public QAbstractListModel
{
    Q_OBJECT

public:
    enum Roles {

        IdRole = Qt::UserRole+1,
        PlaylistIdRole,
        TitleRole,
        ArtistRole,
        DateRole,
        VideoCountRole,
        ThumbnailRole,
        DescriptionRole
    };

public:
    explicit YouTubeUserPlaylistListModel(Session *session, QObject *parent = 0);
    ~YouTubeUserPlaylistListModel();
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role = Qt::DisplayRole) const;
    inline QSharedPointer<PlaylistItem> get(int row) const { return m_session->youtube()->playlists()->at(row); }

private slots:
    void onPlaylistAdded(int row);
    void onPlaylistRemoved(int row);
    void onPlaylistUpdated(int row);
    void onThumbnailReady();

private:
    Session *m_session;
    ThumbnailCache *m_cache;
};

#endif // YOUTUBEUSERPLAYLISTLISTMODEL_H
