#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H

#include "abstractdialog.h"
#include "session.h"
#include "mediaplayerselector.h"
#include "screenorientationselector.h"
#include "languageselector.h"
#include "playbackqualitydialog.h"
#include "downloadqualitydialog.h"
#include "searchoptionsdialog.h"
#include <QCheckBox>
#include <QLineEdit>
#include <QPushButton>
#include <QScrollArea>
#include <QDialogButtonBox>
#include <QGridLayout>

class SettingsDialog : public AbstractDialog
{
    Q_OBJECT
public:
    explicit SettingsDialog(Session *session, QWidget *parent = 0);

private slots:
    void saveSettings();
    void showFileDialog();
    void showSearchOptionsDialog();
    void showPlaybackQualityDialog();
    void showDownloadQualityDialog();
    void setYouTubePrivateAccess(bool enable);
    void setDailymotionPrivateAccess(bool enable);
    void onMediaPlayerChanged(const QString &player);

private:
    void loadSettings();
    void setLandscapeLayout();
    void setPortraitLayout();
    void scheduleEvents();
    void clearEvents();
    
private:
    Session *m_session;
    QCheckBox *m_transferStatusCheckbox;
    QCheckBox *m_safeSearchCheckbox;
    QCheckBox *m_eventFeedCheckbox;
    QPushButton *m_searchButton;
    QPushButton *m_playbackButton;
    QPushButton *m_downloadButton;
    QMaemo5ValueButton *m_downloadFolderSelector;
    QString m_downloadPath;
    MediaPlayerSelector *m_mediaPlayerSelector;
    ScreenOrientationSelector *m_orientationSelector;
    LanguageSelector *m_languageSelector;
    QLineEdit *m_mediaPlayerCommandEdit;
    QCheckBox *m_youtubePrivateCheckbox;
    QCheckBox *m_dailymotionPrivateCheckbox;
    QDialogButtonBox *m_buttonBox;
    QScrollArea *m_scrollArea;
    PlaybackQualityDialog *m_playbackDialog;
    DownloadQualityDialog *m_downloadDialog;
    SearchOptionsDialog *m_searchDialog;
    QGridLayout *m_grid;
    bool m_eventFeedEnabled;
};

#endif // SETTINGSDIALOG_H
