#ifndef ARCHIVELISTMODEL_H
#define ARCHIVELISTMODEL_H

#include "session.h"
#include <QSortFilterProxyModel>
#include <QFileSystemModel>

class ArchiveListModel : public QSortFilterProxyModel
{
    Q_OBJECT

public:
    enum Roles {

        FilePathRole = Qt::UserRole+1,
        TitleRole,
        TitleMatchRole,
        DateRole,
        ThumbnailPathRole,
        UrlRole
    };

public:
    explicit ArchiveListModel(Session *session, QObject *parent = 0);
    QString regexMatch(QString str) const;
    inline QString query() const { return m_query; }
    QVariant data(const QModelIndex &index, int role) const;
    QSharedPointer<VideoItem> get(const QModelIndex &index) const;
    QModelIndex rootIndex() const;
    bool filterAcceptsRow(int source_row, const QModelIndex &source_parent) const;

public slots:
    void setQuery(const QString &query);
    void deleteVideo(const QModelIndex &index);

signals:
    void directoryLoaded(const QString &path);
    void alert(const QString &message);
    void warning(const QString &message);

private:
    Session *m_session;
    QFileSystemModel *m_model;
    QString m_query;
};

#endif // ARCHIVELISTMODEL_H
