#ifndef YOUTUBEVIDEOINFOWINDOW_H
#define YOUTUBEVIDEOINFOWINDOW_H

#include "stackedwindow.h"
#include "youtubevideodescriptiontab.h"
#include "youtubevideocommentstab.h"
#include "youtuberelatedvideostab.h"
#include <QStackedWidget>
#include <QActionGroup>
#include <QMenu>

class YouTubeVideoInfoWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit YouTubeVideoInfoWindow(Session *session, QSharedPointer<VideoItem> video, QWidget *parent);

private:
    void clearMenuActions();

private slots:
    void showInfo();
    void showComments();
    void showRelatedVideos();

private:
    QSharedPointer<VideoItem> m_video;
    QMenu *m_menu;
    QActionGroup *m_actionGroup;
    QAction *m_infoAction;
    QAction *m_commentsAction;
    QAction *m_relatedAction;
    QStackedWidget *m_tabWidget;
    YouTubeVideoDescriptionTab *m_infoTab;
    YouTubeVideoCommentsTab *m_commentsTab;
    YouTubeRelatedVideosTab *m_relatedTab;
};

#endif // YOUTUBEVIDEOINFOWINDOW_H
