#ifndef YOUTUBECOMMENTDIALOG_H
#define YOUTUBECOMMENTDIALOG_H

#include "abstractdialog.h"
#include "session.h"
#include "thumbnaillabel.h"
#include <QTextEdit>
#include <QLabel>
#include <QPushButton>
#include <QDialogButtonBox>
#include <QGridLayout>
#include <QScrollArea>

class YouTubeCommentDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit YouTubeCommentDialog(Session *session, QSharedPointer<VideoItem> video, QSharedPointer<CommentItem> initialComment = QSharedPointer<CommentItem>(), QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onCommentTextChanged();
    void setAvatar();
    void submitComment();

private:
    Session *m_session;
    QSharedPointer<VideoItem> m_video;
    QSharedPointer<CommentItem> m_initialComment;
    QTextEdit *m_commentEdit;
    ThumbnailLabel *m_avatar;
    QLabel *m_initialCommentLabel;
    QDialogButtonBox *m_buttonBox;
    QPushButton *m_doneButton;
    QScrollArea *m_scrollArea;
    QGridLayout *m_grid;
};

#endif // YOUTUBECOMMENTDIALOG_H
