#include "playbacklistmodel.h"

PlaybackListModel::PlaybackListModel(ThumbnailCache *cache, QObject *parent) :
    AbstractVideoListModel(cache, parent)
{
}

void PlaybackListModel::insertVideo(int row, QSharedPointer<VideoItem> video) {
    AbstractVideoListModel::insertVideo(row, QSharedPointer<VideoItem>(video));
    emit alert(tr("Video added to playback queue"));
    emit countChanged();
}

void PlaybackListModel::addVideo(QSharedPointer<VideoItem> video) {
    AbstractVideoListModel::appendVideo(QSharedPointer<VideoItem>(video));
    emit alert(tr("Video added to playback queue"));
    emit countChanged();
}

void PlaybackListModel::addVideos(QList< QSharedPointer<VideoItem> > videos) {
    while (!videos.isEmpty()) {
        AbstractVideoListModel::appendVideo(QSharedPointer<VideoItem>(videos.takeFirst()));
    }

    emit alert(tr("Videos added to playback queue"));
    emit countChanged();
}

void PlaybackListModel::removeVideo(int row) {
    removeRow(row);
    emit countChanged();
}

void PlaybackListModel::removeVideos() {
    qSort(m_checkedRows.begin(), m_checkedRows.end(), qGreater<int>());

    for (int i = 0; i < m_checkedRows.size(); i++) {
        removeVideo(m_checkedRows.at(i));
    }

    checkNone();
    emit countChanged();
}
