#include "homewindow.h"
#include "utils.h"
#include <QtGui>
#include <QSettings>
#include <QTranslator>

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);
    app.setApplicationName("cuteTube");
    app.setApplicationVersion(Utils::versionNumberString());

    QSettings settings("Marxian", "cuteTube");
    settings.beginGroup("System");
    QString lang = settings.value("language").toString();
    settings.endGroup();

    QTranslator translator;
    translator.load(QString("/opt/cutetube/translations/cutetube_") + lang);
    app.installTranslator(&translator);

    HomeWindow window;
    window.show();

    return app.exec();
}
