#ifndef LINKGOOGLEACCOUNTDIALOG_H
#define LINKGOOGLEACCOUNTDIALOG_H

#include "abstractdialog.h"
#include "session.h"
#include <QLineEdit>
#include <QPushButton>
#include <QDialogButtonBox>
#include <QScrollArea>
#include <QGridLayout>
#include <QStringListModel>
#include <QListView>
#include <QLabel>

class SuggestedUsernamesDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit SuggestedUsernamesDialog(QWidget *parent = 0);
    void setSuggestedUsernames(const QStringList &usernames);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onItemClicked(const QModelIndex &index);

signals:
    void usernameChosen(const QString &username);

private:
    QStringListModel *m_model;
    QListView *m_listView;
    QGridLayout *m_grid;
};

class LinkGoogleAccountDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit LinkGoogleAccountDialog(Session *session, QWidget *parent = 0);
    
private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onUsernameTextChanged(const QString &text);
    void showSuggestedUsernames(const QStringList &usernames);
    void checkUsername();
    void onUsernameAvailable();
    void onUsernameUnavailable();

private:
    Session *m_session;
    QLineEdit *m_usernameEdit;
    QLabel *m_messageLabel;
    QDialogButtonBox *m_buttonBox;
    QPushButton *m_doneButton;
    QScrollArea *m_scrollArea;
    QGridLayout *m_grid;
    SuggestedUsernamesDialog *m_dialog;
};

#endif // LINKGOOGLEACCOUNTDIALOG_H
