#include "archivevideolistdelegate.h"
#include "archivelistmodel.h"
#include <QApplication>
#include <QStaticText>
#include <QDebug>

ArchiveVideoListDelegate::ArchiveVideoListDelegate(QListView *parent) :
    QStyledItemDelegate(parent),
    m_view(parent)
{
}

void ArchiveVideoListDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    if ((option.state) & (QStyle::State_Selected)) {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundPressed.png"));
    }
    else {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundNormal.png"));
    }

    QRect titleRect = option.rect;
    titleRect.setLeft(titleRect.left() + 170);
    titleRect.setRight(titleRect.right() - 5);
    titleRect.setTop(titleRect.top() + 5);
    titleRect.setHeight(60);

    QStaticText titleText(index.data(ArchiveListModel::TitleRole).toString());
    titleText.setTextWidth(titleRect.width());

    painter->setClipRect(titleRect);
    painter->drawStaticText(titleRect.topLeft(), titleText);
    painter->setClipping(false);

    QFont oldFont = painter->font();
    QFont smallFont;
    smallFont.setPixelSize(18);
    painter->setFont(smallFont);
    QPen oldPen = painter->pen();
    QPen newPen(QColor("#4d4d4d"));
    painter->setPen(newPen);

    QRect infoRect = option.rect;
    infoRect.setLeft(titleRect.left());
    infoRect.setRight(titleRect.right());
    infoRect.setBottom(infoRect.bottom() - 5);

    painter->drawText(infoRect, Qt::TextWordWrap | Qt::AlignBottom, index.data(ArchiveListModel::DateRole).toDateTime().toString("dd/MM/yyyy | HH:mm"));

    QRect imageRect = option.rect;
    imageRect.setLeft(imageRect.left() + 5);
    imageRect.setTop(imageRect.top() + 5);
    imageRect.setWidth(160);
    imageRect.setHeight(120);

    QImage image(index.data(ArchiveListModel::ThumbnailPathRole).toString());

    if (!image.isNull()) {
        painter->drawImage(imageRect, image.scaledToWidth(160, Qt::SmoothTransformation));
    }
    else {
        painter->drawImage(imageRect.left() + 56, imageRect.top() + 36, QImage("/usr/share/icons/hicolor/48x48/hildon/general_video_file.png"));
    }

    painter->drawRect(imageRect);
    painter->setFont(oldFont);
    painter->setPen(oldPen);
}

QSize ArchiveVideoListDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(option);
    Q_UNUSED(index);

    return QSize(m_view->width(), 130);
}
