#ifndef ABSTRACTPLAYLISTLISTMODEL_H
#define ABSTRACTPLAYLISTLISTMODEL_H

#include "thumbnailcache.h"
#include "playlistitem.h"
#include <QAbstractListModel>
#include <QSharedPointer>

class AbstractPlaylistListModel : public QAbstractListModel
{
    Q_OBJECT

public:
    enum Roles {

        IdRole = Qt::UserRole+1,
        PlaylistIdRole,
        TitleRole,
        ArtistRole,
        DateRole,
        VideoCountRole,
        ThumbnailRole,
        DescriptionRole
    };

public:
    explicit AbstractPlaylistListModel(ThumbnailCache *cache, QObject *parent = 0);
    ~AbstractPlaylistListModel();
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role) const;
    QSharedPointer<PlaylistItem> get(int row) const;
    void insertPlaylist(int row, QSharedPointer<PlaylistItem> playlist);
    void appendPlaylist(QSharedPointer<PlaylistItem> playlist);
    bool removePlaylist(const QString &id);
    
protected:
    bool removeRow(int row, const QModelIndex &parent = QModelIndex());

protected slots:
    void onThumbnailReady();

protected:
    ThumbnailCache *m_cache;
    QList< QSharedPointer<PlaylistItem> > m_list;
    
};

#endif // ABSTRACTPLAYLISTLISTMODEL_H
