#include "youtubeplaylistlistwindow.h"
#include "youtubeplaylistvideoswindow.h"
#include "youtubeplaylistdelegate.h"

YouTubePlaylistListWindow::YouTubePlaylistListWindow(Session *session, QWidget *parent) :
    StackedWindow(session, parent),
    m_listView(new ListView(this)),
    m_model(new YouTubePlaylistListModel(m_session, this)),
    m_noResultsLabel(new QLabel(QString("<p style='color:#4d4d4d;font-size:40px;'><center><b>%1</b></center></p>").arg(tr("No playlists found")), this))
{
    setCentralWidget(m_listView);

    m_listView->setModel(m_model);
    m_listView->setItemDelegate(new YouTubePlaylistDelegate(m_listView));
    m_noResultsLabel->hide();

    connect(m_model, SIGNAL(loadingChanged()), this, SLOT(onLoadingChanged()));
    connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    connect(m_listView, SIGNAL(atEnd()), m_model, SLOT(getMorePlaylists()));

    onOrientationChanged();
}

void YouTubePlaylistListWindow::setLandscapeLayout() {
    m_noResultsLabel->setFixedSize(800, 400);
}

void YouTubePlaylistListWindow::setPortraitLayout() {
    m_noResultsLabel->setFixedSize(480, 700);
}

void YouTubePlaylistListWindow::search(const QString &query, Queries::QueryOrder order) {
    setWindowTitle(tr("Search") + QString(" ('%1')").arg(query));
    m_model->search(query, order);
}

void YouTubePlaylistListWindow::onLoadingChanged() {
    toggleBusy(m_model->loading());
    m_noResultsLabel->setVisible((!m_model->loading()) && (m_model->rowCount() == 0));
}

void YouTubePlaylistListWindow::onItemClicked(const QModelIndex &index) {
    if (index.isValid()) {
        showPlaylist(m_model->get(index.row()));
    }
}

void YouTubePlaylistListWindow::showPlaylist(QSharedPointer<PlaylistItem> playlist) {
    YouTubePlaylistVideosWindow *window = new YouTubePlaylistVideosWindow(m_session, playlist, this);
    window->show();
}
