#include "xtubevideolistdelegate.h"
#include "abstractvideolistmodel.h"
#include <QApplication>

XTubeVideoListDelegate::XTubeVideoListDelegate(QListView *parent) :
    QStyledItemDelegate(parent),
    m_view(parent)
{
}

void XTubeVideoListDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    if ((option.state) & (QStyle::State_Selected)) {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundPressed.png"));
    }
    else {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundNormal.png"));
    }

    QRect titleRect = option.rect;
    titleRect.setLeft(titleRect.left() + 170);
    titleRect.setRight(titleRect.right() - 5);
    titleRect.setTop(titleRect.top() + 5);
    titleRect.setHeight(60);

    painter->drawText(titleRect, Qt::TextWordWrap, index.data(AbstractVideoListModel::TitleRole).toString());

    QFont oldFont = painter->font();
    QFont smallFont;
    smallFont.setPixelSize(18);
    painter->setFont(smallFont);
    QPen oldPen = painter->pen();
    QPen newPen(QColor("#4d4d4d"));
    painter->setPen(newPen);

    QRect infoRect = option.rect;
    infoRect.setLeft(titleRect.left());
    infoRect.setRight(titleRect.right());
    infoRect.setBottom(infoRect.bottom() - 5);

    painter->drawText(infoRect, Qt::AlignBottom, QString("%1  views").arg(index.data(AbstractVideoListModel::ViewCountRole).toInt()));

    QRect imageRect = option.rect;
    imageRect.setLeft(imageRect.left() + 5);
    imageRect.setTop(imageRect.top() + 5);
    imageRect.setWidth(160);
    imageRect.setHeight(120);

    QImage image = index.data(AbstractVideoListModel::ThumbnailRole).value<QImage>();

    if (!image.isNull()) {
        painter->drawImage(imageRect, image);
    }
    else {
        painter->drawImage(imageRect.left() + 56, imageRect.top() + 36, QImage("/usr/share/icons/hicolor/48x48/hildon/general_video_file.png"));
    }

    painter->drawRect(imageRect);

    int duration = index.data(AbstractVideoListModel::DurationRole).toInt();

    QRect durationRect = imageRect;
    durationRect.setLeft(duration < 3600 ? durationRect.right() - 50 : durationRect.right() - 70);
    durationRect.setTop(durationRect.bottom() - 20);

    painter->setOpacity(0.5);
    painter->fillRect(durationRect, Qt::black);
    painter->setOpacity(1);

    newPen.setColor(Qt::white);
    painter->setPen(newPen);

    painter->drawText(durationRect, Qt::AlignCenter, Utils::durationFromSecs(duration));

    painter->setFont(oldFont);
    painter->setPen(oldPen);
}

QSize XTubeVideoListDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(option);
    Q_UNUSED(index);

    return QSize(m_view->width(), 130);
}
