#include "transferitem.h"

TransferItem::TransferItem(QObject *parent) :
    QObject(parent),
    m_transferType(TransferItem::VideoDownload),
    m_priority(TransferItem::NormalPriority),
    m_progress(0.0),
    m_eta(0),
    m_size(0)
{
}

TransferItem::TransferItem(QSharedPointer<VideoItem> video, TransferItem::TransferType type, TransferItem::Status status, QObject *parent) :
    QObject(parent),
    m_transferType(type),
    m_service(video.data()->service()),
    m_id(video.data()->videoId()),
    m_title(video.data()->title()),
    m_thumbnailUrl(video.data()->thumbnailUrl()),
    m_status(status),
    m_priority(TransferItem::NormalPriority),
    m_progress(0.0),
    m_eta(0),
    m_size(0)
{
    video.data()->setDownloaded(true);
}

TransferItem::TransferItem(const VideoMetadata &upload, QObject *parent) :
    QObject(parent),
    m_transferType(TransferItem::VideoUpload),
    m_service(Services::YouTube),
    m_title(upload.title()),
    m_status(TransferItem::Queued),
    m_priority(TransferItem::HighPriority),
    m_progress(0.0),
    m_eta(0),
    m_size(0),
    m_upload(upload)
{
}

QString TransferItem::statusText() const {
    switch (status()) {
    case Queued:
        return tr("Queued");
    case Paused:
        return tr("Paused");
    case Active:
        return tr("In progress");
    case Cancelled:
        return tr("Cancelled");
    case Failed:
        return tr("Failed");
    default:
        return QString();
    }
}

QString TransferItem::priorityText() const {
    switch (priority()) {
    case HighPriority:
        return tr("High");
    case NormalPriority:
        return tr("Normal");
    case LowPriority:
        return tr("Low");
    default:
        return QString();
    }
}
